package com.ebikecharge.openservices.cloudapi.entity.response;

import java.io.Serializable;
import java.util.Objects;

/**
 * 银行卡认证回应
 */
public class BankcardCertResponse implements Serializable {

    private int status;                 // 为0表示认证成功；为负表示失败
    private String msg;                 // 失败原因

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public String toString() {
        return "BankcardCertResponse{" +
                "status=" + status +
                ", msg='" + msg + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        BankcardCertResponse that = (BankcardCertResponse) o;
        return status == that.status &&
                Objects.equals(msg, that.msg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, msg);
    }

}
