package com.ebikecharge.openservices.testing.entity.request;

import java.io.Serializable;
import java.util.Objects;

public class BindingRequest implements Serializable {

    private String orgNo;                       // 检测单位编号
    private String chargedeviceNo;              // 充电设备编号（二维码编号）
    private String deviceId;                    // 设备通讯标识（）
    private int plugCount;                      // 插座个数
    private String modelNo;                     // 型号规格
    private String binder;                      // 绑定人员工号

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getChargedeviceNo() {
        return chargedeviceNo;
    }

    public void setChargedeviceNo(String chargedeviceNo) {
        this.chargedeviceNo = chargedeviceNo;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public int getPlugCount() {
        return plugCount;
    }

    public void setPlugCount(int plugCount) {
        this.plugCount = plugCount;
    }

    public String getModelNo() {
        return modelNo;
    }

    public void setModelNo(String modelNo) {
        this.modelNo = modelNo;
    }

    public String getBinder() {
        return binder;
    }

    public void setBinder(String binder) {
        this.binder = binder;
    }

    @Override
    public String toString() {
        return "BindingRequest{" +
                "orgNo='" + orgNo + '\'' +
                ", chargedeviceNo='" + chargedeviceNo + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", plugCount=" + plugCount +
                ", modelNo='" + modelNo + '\'' +
                ", binder='" + binder + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        BindingRequest that = (BindingRequest) o;
        return plugCount == that.plugCount &&
                Objects.equals(orgNo, that.orgNo) &&
                Objects.equals(chargedeviceNo, that.chargedeviceNo) &&
                Objects.equals(deviceId, that.deviceId) &&
                Objects.equals(modelNo, that.modelNo) &&
                Objects.equals(binder, that.binder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgNo, chargedeviceNo, deviceId, plugCount, modelNo, binder);
    }

}
