package com.ebikecharge.openservices.testing.service;

import com.ebikecharge.openservices.testing.entity.request.BindingRequest;
import com.ebikecharge.openservices.testing.entity.request.TestingRequest;
import com.ebikecharge.openservices.testing.entity.response.BindingResponse;
import com.ebikecharge.openservices.testing.entity.response.TestingResponse;

/**
 * 出厂检测服务
 */
public interface TestingService {

    /**
     * 设备绑定
     * @param bindingRequest
     *              绑定请求
     * @return 绑定回应
     */
    BindingResponse bindTestDevice(BindingRequest bindingRequest);

    /**
     * 依次开启
     * @param testingRequest
     *              检测请求
     * @return 检测回应
     */
    TestingResponse successiveStart(TestingRequest testingRequest);

    /**
     * 依次结束
     * @param testingRequest
     *              检测请求
     * @return 检测回应
     */
    TestingResponse successiveStop(TestingRequest testingRequest);

    /**
     * 失败重发
     * @param testingRequest
     *              检测请求
     * @return 检测回应
     */
    TestingResponse failureToResend(TestingRequest testingRequest);

}
