package com.ebikecharge.openservices.testing.service.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.TestingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargeDevice;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargePlug;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeTestingService;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import com.ebikecharge.openservices.testing.entity.request.BindingRequest;
import com.ebikecharge.openservices.testing.entity.request.TestingRequest;
import com.ebikecharge.openservices.testing.entity.response.BindingResponse;
import com.ebikecharge.openservices.testing.entity.response.TestingResponse;
import com.ebikecharge.openservices.testing.service.TestingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 *
 */
public class TestingServiceImpl implements TestingService {

    private final long interval = 3L;         // 3秒

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 60, 600, TimeUnit.SECONDS, new LinkedBlockingDeque<>());

    @Resource(name = "testingDao")
    private TestingDao testingDao;

    @Resource(name = "ebikeTestingService")
    private EBikeTestingService ebikeTestingService;

    @Override
    public BindingResponse bindTestDevice(BindingRequest bindingRequest) {
        BindingResponse res = new BindingResponse();
        res.setStatus(-1);
        res.setMsg("设备绑定失败");
        return res;
    }

    @Override
    public TestingResponse successiveStart(TestingRequest testingRequest) {
        TestingResponse res = new TestingResponse();
        res.setStatus(-1);
        res.setMsg("依次开启失败");
        if(testingRequest != null) {
            TestingChargeDevice tcd = testingDao.getTestingChargeDeviceByChargedeviceNo(testingRequest.getChargedeviceNo());
            if(tcd != null) {
                if(StringUtils.equals(tcd.getOrgNo(), testingRequest.getOrgNo())) {
                    Integer testCount = tcd.getTestCount();
                    tcd.setTestCount(testCount != null ? testCount + 1 : 1);
                    tcd.setLatestTester(testingRequest.getTester());
                    tcd.setLatestTestTime(new Date());
                    tcd.setLatestTestResult("T");
                    testingDao.updateTestingChargeDevice(tcd);
                    Integer plugCount = tcd.getPlugCount();
                    Thread thread = new Thread(() -> {
                        for(int i = 1; i <= plugCount; i++) {
                            TestingChargePlug tcp = testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), i);
                            tcp.setTestStatus("01");                        // 01 - 正在开启
                            tcp.setTestStatusDesc("正在开启，请稍候...");
                            tcp.setTester(testingRequest.getTester());
                            tcp.setStartTestTime(new Date());
                            tcp.setEndTestTime(null);
                            testingDao.updateTestingChargePlug(tcp);
                            ebikeTestingService.publish2device(tcd.getDeviceId(), "start#" + i + "#60#60", "start");
                            //
                            for(int j = 1; j <= 7; j++) {
                                try {
                                    TimeUnit.SECONDS.sleep(interval);
                                }
                                catch(InterruptedException _ie) {
                                    logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                                }
                                tcp = testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), i);
                                if(StringUtils.equals("02", tcp.getTestStatus())) {     // 02 - 开启成功
                                    break;
                                }
                                else {
                                    if(j == 7) {
                                        tcp.setTestStatus("04");
                                        tcp.setTestStatusDesc("开启超时");
                                        testingDao.updateTestingChargePlug(tcp);
                                    }
                                    else {
                                        ebikeTestingService.publish2device(tcd.getDeviceId(), "start#" + i + "#60#60", "start");
                                    }
                                }
                            }
                            /*try {
                                TimeUnit.SECONDS.sleep(interval);
                            }
                            catch(InterruptedException _ie) {
                                logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                            }*/
                        }
                    });
                    pool.execute(thread);
                    res.setStatus(0);
                    res.setMsg("依次开启成功");
                }
                else {
                    res.setStatus(-1);
                    res.setMsg("依次开启失败：该充电设备不在管辖范围内");
                }
            }
            else {
                res.setStatus(-1);
                res.setMsg("依次开启失败：该充电设备没有绑定");
            }
        }
        else {
            res.setStatus(-1);
            res.setMsg("依次开启失败：请求参数为空");
        }
        return res;
    }

    @Override
    public TestingResponse successiveStop(TestingRequest testingRequest) {
        TestingResponse res = new TestingResponse();
        res.setStatus(-1);
        res.setMsg("依次结束失败");
        if(testingRequest != null) {
            TestingChargeDevice tcd = testingDao.getTestingChargeDeviceByChargedeviceNo(testingRequest.getChargedeviceNo());
            if(tcd != null) {
                if(StringUtils.equals(tcd.getOrgNo(), testingRequest.getOrgNo())) {
                    Integer plugCount = tcd.getPlugCount();
                    Thread thread = new Thread(() -> {
                        int failCount = 0;
                        for(int i = 1; i <= plugCount; i++) {
                            TestingChargePlug tcp = testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), i);
                            tcp.setTestStatus("05");                        // 05 – 正在结束
                            tcp.setTestStatusDesc("正在结束，请稍候...");
                            tcp.setEndTestTime(new Date());
                            testingDao.updateTestingChargePlug(tcp);
                            ebikeTestingService.publish2device(tcd.getDeviceId(), "stop#" + i, "stop");
                            //
                            for(int j = 1; j <= 7; j++) {
                                try {
                                    TimeUnit.SECONDS.sleep(interval);
                                }
                                catch(InterruptedException _ie) {
                                    logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                                }
                                tcp = testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), i);
                                if(StringUtils.equals("07", tcp.getTestStatus())) {     // 07 - 结束成功
                                    break;
                                }
                                else {
                                    if(j == 7) {
                                        tcp.setTestStatus("06");
                                        tcp.setTestStatusDesc("结束超时");
                                        tcp.setEndTestTime(new Date());
                                        testingDao.updateTestingChargePlug(tcp);
                                        failCount++;
                                    }
                                    else {
                                        ebikeTestingService.publish2device(tcd.getDeviceId(), "stop#" + i, "stop");
                                    }
                                }
                            }
                        }
                        TestingChargeDevice tcdTemp = testingDao.getTestingChargeDeviceByChargedeviceNo(tcd.getChargedeviceNo());
                        if(failCount == 0) {
                            tcdTemp.setLatestTestResult("S");       // S – 检测成功；
                        }
                        else {
                            tcdTemp.setLatestTestResult("F");       // F – 检测失败；
                        }
                        testingDao.updateTestingChargeDevice(tcdTemp);
                    });
                    pool.execute(thread);
                    res.setStatus(0);
                    res.setMsg("依次结束成功");
                }
                else {
                    res.setStatus(-1);
                    res.setMsg("依次结束失败：该充电设备不在管辖范围内");
                }
            }
            else {
                res.setStatus(-1);
                res.setMsg("依次结束失败：该充电设备没有绑定");
            }
        }
        else {
            res.setStatus(-1);
            res.setMsg("依次结束失败：请求参数为空");
        }
        return res;
    }

    @Override
    public TestingResponse failureToResend(TestingRequest testingRequest) {
        TestingResponse res = new TestingResponse();
        res.setStatus(-1);
        res.setMsg("失败重发失败");
        return res;
    }

}
