/*
 * Decompiled with CFR 0.152.
 */
package com.ebikecharge.openservices.testing.service.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.TestingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargeDevice;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargePlug;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeTestingService;
import com.ebikecharge.openservices.testing.entity.request.BindingRequest;
import com.ebikecharge.openservices.testing.entity.request.TestingRequest;
import com.ebikecharge.openservices.testing.entity.response.BindingResponse;
import com.ebikecharge.openservices.testing.entity.response.TestingResponse;
import com.ebikecharge.openservices.testing.service.TestingService;
import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingServiceImpl
implements TestingService {
    private final long interval = 3L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 60, 600L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    @Resource(name="testingDao")
    private TestingDao testingDao;
    @Resource(name="ebikeTestingService")
    private EBikeTestingService ebikeTestingService;

    public BindingResponse bindTestDevice(BindingRequest bindingRequest) {
        BindingResponse res = new BindingResponse();
        res.setStatus(-1);
        res.setMsg("\u8bbe\u5907\u7ed1\u5b9a\u5931\u8d25");
        return res;
    }

    public TestingResponse successiveStart(TestingRequest testingRequest) {
        TestingResponse res = new TestingResponse();
        res.setStatus(-1);
        res.setMsg("\u4f9d\u6b21\u5f00\u542f\u5931\u8d25");
        if (testingRequest != null) {
            TestingChargeDevice tcd = this.testingDao.getTestingChargeDeviceByChargedeviceNo(testingRequest.getChargedeviceNo());
            if (tcd != null) {
                if (StringUtils.equals((CharSequence)tcd.getOrgNo(), (CharSequence)testingRequest.getOrgNo())) {
                    Integer testCount = tcd.getTestCount();
                    tcd.setTestCount(Integer.valueOf(testCount != null ? testCount + 1 : 1));
                    tcd.setLatestTester(testingRequest.getTester());
                    tcd.setLatestTestTime(new Date());
                    tcd.setLatestTestResult("T");
                    this.testingDao.updateTestingChargeDevice(tcd);
                    Integer plugCount = tcd.getPlugCount();
                    Thread thread = new Thread(() -> {
                        block2: for (int i = 1; i <= plugCount; ++i) {
                            TestingChargePlug tcp = this.testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), Integer.valueOf(i));
                            tcp.setTestStatus("01");
                            tcp.setTestStatusDesc("\u6b63\u5728\u5f00\u542f\uff0c\u8bf7\u7a0d\u5019...");
                            tcp.setTester(testingRequest.getTester());
                            tcp.setStartTestTime(new Date());
                            tcp.setEndTestTime(null);
                            this.testingDao.updateTestingChargePlug(tcp);
                            this.ebikeTestingService.publish2device(tcd.getDeviceId(), "start#" + i + "#60#60", "start");
                            for (int j = 1; j <= 7; ++j) {
                                try {
                                    TimeUnit.SECONDS.sleep(3L);
                                }
                                catch (InterruptedException _ie) {
                                    this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                                }
                                tcp = this.testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), Integer.valueOf(i));
                                if (StringUtils.equals((CharSequence)"02", (CharSequence)tcp.getTestStatus())) continue block2;
                                if (j == 7) {
                                    tcp.setTestStatus("04");
                                    tcp.setTestStatusDesc("\u5f00\u542f\u8d85\u65f6");
                                    this.testingDao.updateTestingChargePlug(tcp);
                                    continue;
                                }
                                this.ebikeTestingService.publish2device(tcd.getDeviceId(), "start#" + i + "#60#60", "start");
                            }
                        }
                    });
                    this.pool.execute(thread);
                    res.setStatus(0);
                    res.setMsg("\u4f9d\u6b21\u5f00\u542f\u6210\u529f");
                } else {
                    res.setStatus(-1);
                    res.setMsg("\u4f9d\u6b21\u5f00\u542f\u5931\u8d25\uff1a\u8be5\u5145\u7535\u8bbe\u5907\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185");
                }
            } else {
                res.setStatus(-1);
                res.setMsg("\u4f9d\u6b21\u5f00\u542f\u5931\u8d25\uff1a\u8be5\u5145\u7535\u8bbe\u5907\u6ca1\u6709\u7ed1\u5b9a");
            }
        } else {
            res.setStatus(-1);
            res.setMsg("\u4f9d\u6b21\u5f00\u542f\u5931\u8d25\uff1a\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        return res;
    }

    public TestingResponse successiveStop(TestingRequest testingRequest) {
        TestingResponse res = new TestingResponse();
        res.setStatus(-1);
        res.setMsg("\u4f9d\u6b21\u7ed3\u675f\u5931\u8d25");
        if (testingRequest != null) {
            TestingChargeDevice tcd = this.testingDao.getTestingChargeDeviceByChargedeviceNo(testingRequest.getChargedeviceNo());
            if (tcd != null) {
                if (StringUtils.equals((CharSequence)tcd.getOrgNo(), (CharSequence)testingRequest.getOrgNo())) {
                    Integer plugCount = tcd.getPlugCount();
                    Thread thread = new Thread(() -> {
                        int failCount = 0;
                        block2: for (int i = 1; i <= plugCount; ++i) {
                            TestingChargePlug tcp = this.testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), Integer.valueOf(i));
                            tcp.setTestStatus("05");
                            tcp.setTestStatusDesc("\u6b63\u5728\u7ed3\u675f\uff0c\u8bf7\u7a0d\u5019...");
                            tcp.setEndTestTime(new Date());
                            this.testingDao.updateTestingChargePlug(tcp);
                            this.ebikeTestingService.publish2device(tcd.getDeviceId(), "stop#" + i, "stop");
                            for (int j = 1; j <= 7; ++j) {
                                try {
                                    TimeUnit.SECONDS.sleep(3L);
                                }
                                catch (InterruptedException _ie) {
                                    this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                                }
                                tcp = this.testingDao.getTestingChargePlugByChargedeviceNoAndPlugSn(tcd.getChargedeviceNo(), Integer.valueOf(i));
                                if (StringUtils.equals((CharSequence)"07", (CharSequence)tcp.getTestStatus())) continue block2;
                                if (j == 7) {
                                    tcp.setTestStatus("06");
                                    tcp.setTestStatusDesc("\u7ed3\u675f\u8d85\u65f6");
                                    tcp.setEndTestTime(new Date());
                                    this.testingDao.updateTestingChargePlug(tcp);
                                    ++failCount;
                                    continue;
                                }
                                this.ebikeTestingService.publish2device(tcd.getDeviceId(), "stop#" + i, "stop");
                            }
                        }
                        TestingChargeDevice tcdTemp = this.testingDao.getTestingChargeDeviceByChargedeviceNo(tcd.getChargedeviceNo());
                        if (failCount == 0) {
                            tcdTemp.setLatestTestResult("S");
                        } else {
                            tcdTemp.setLatestTestResult("F");
                        }
                        this.testingDao.updateTestingChargeDevice(tcdTemp);
                    });
                    this.pool.execute(thread);
                    res.setStatus(0);
                    res.setMsg("\u4f9d\u6b21\u7ed3\u675f\u6210\u529f");
                } else {
                    res.setStatus(-1);
                    res.setMsg("\u4f9d\u6b21\u7ed3\u675f\u5931\u8d25\uff1a\u8be5\u5145\u7535\u8bbe\u5907\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185");
                }
            } else {
                res.setStatus(-1);
                res.setMsg("\u4f9d\u6b21\u7ed3\u675f\u5931\u8d25\uff1a\u8be5\u5145\u7535\u8bbe\u5907\u6ca1\u6709\u7ed1\u5b9a");
            }
        } else {
            res.setStatus(-1);
            res.setMsg("\u4f9d\u6b21\u7ed3\u675f\u5931\u8d25\uff1a\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        return res;
    }

    public TestingResponse failureToResend(TestingRequest testingRequest) {
        TestingResponse res = new TestingResponse();
        res.setStatus(-1);
        res.setMsg("\u5931\u8d25\u91cd\u53d1\u5931\u8d25");
        return res;
    }
}

