package com.iesms.openservices.esmgmt.dao;


import com.iesms.openservices.esmgmt.request.EnergyAnalysisAlreadyReportRequest;
import com.iesms.openservices.esmgmt.request.EnergyAnalysisCreateReportRequest;
import com.iesms.openservices.esmgmt.response.*;

import java.util.List;

public interface EnergyAnalysisCreateReportDao {

    /**
     * 插入用能分析报告报表
     * @param pojo
     * @return
     */
    int addEnergyAnalysisReport(EnergyAnalysisCreateReportRequest pojo);

    /**
     * 用电量月统计（按用能客户）
     * @param pojo
     * @return
     */
    List<EnergyAnalysisCePartEconsMonthResponse> selCeCustMonthByUnitId(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 用电量月统计（按用能客户）
     * @param pojo
     * @return
     */
    int selCeCustMonthByUnitIdTotal(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 用电量年统计（按用能客户）
     * @param pojo
     * @return
     */
    List<EnergyAnalysisCePartEconsMonthResponse> selCeCustYearByUnitId(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 用电量年统计（按用能客户）
     * @param pojo
     * @return
     */
    int selCeCustYearByUnitIdTotal(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 用电量月统计（按用能容器）
     * @param pojo
     * @return
     */
    List<EnergyAnalysisCecntrEconsResponse> selCecntrMonthByUnitId(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 用电量月统计（按用能容器）
     * @param pojo
     * @return
     */
    int selCecntrMonthByUnitIdTotal(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 用电量年统计（按用能容器）
     * @param pojo
     * @return
     */
    List<EnergyAnalysisCecntrEconsResponse> selCecntrYearByUnitId(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 用电量年统计（按用能容器）
     * @param pojo
     * @return
     */
    int selCecntrYearByUnitIdTotal(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 用电量月统计（按用能客户建筑空间设备分类）
     * @param pojo
     * @return
     */
    List<EnergyAnalysisCebsdEconsResponse> selCebsdMonthByUnitId(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 用电量月统计（按用能客户建筑空间设备分类）
     * @param pojo
     * @return
     */
    int selCebsdMonthByUnitIdTotal(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 用电量年统计（按用能客户建筑空间设备分类）
     * @param pojo
     * @return
     */
    List<EnergyAnalysisCebsdEconsResponse> selCebsdYearByUnitId(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 用电量年统计（按用能客户建筑空间设备分类）
     * @param pojo
     * @return
     */
    int selCebsdYearByUnitIdTotal(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询能耗趋势（按日）
     * @param pojo
     * @return
     */
    List<EnergyConsumptionTrendResponse> selConsumptionTrendDay(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询能耗趋势（按季）
     * @param pojo
     * @return
     */
    List<EnergyConsumptionTrendResponse> selConsumptionTrendMonth(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询能耗趋势（按年）
     * @param pojo
     * @return
     */
    List<EnergyConsumptionTrendResponse> selConsumptionTrendYear(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询管理节能收益（按日）
     * @param pojo
     * @return
     */
    List<EnergySavingIncomeResponse> selSavingIncomeDay(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询管理节能收益（按季或按年）
     * @param pojo
     * @return
     */
    List<EnergySavingIncomeResponse> selSavingIncomeMonthOrYear(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询计划外事件all（按日or按季度or按年）
     * @param pojo
     * @return
     */
    List<EnergyUnplannedEventsResponse> selUnplannedEventsAll(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 查询计划外事件已处理的（按日or按季度or按年）
     * @param pojo
     * @return
     */
    List<EnergyUnplannedEventsResponse> selUnplannedEventsProcessed(EnergyAnalysisAlreadyReportRequest pojo);

    /**
     * 计划外事件总有效处理率（全部）
     */
    double selUnplannedEventsAllTotal(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 计划外事件总有效处理率（已处理）
     */
    double selUnplannedEventsProcessedTotal(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 计划外事件有效管控时间（已处理）
     */
    double selUnplannedEventsProcessedTime(EnergyAnalysisAlreadyReportRequest pojo);
    /**
     * 累计管控收益
     */
    String selProfitEsMgmt(EnergyAnalysisAlreadyReportRequest pojo);
}
