package com.iesms.openservices.esmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.BenchmarkDataDao;
import com.iesms.openservices.esmgmt.entity.*;
import com.iesms.openservices.esmgmt.response.CeHkBaseConfigHouseTypeVo;
import com.iesms.openservices.esmgmt.response.CeStatCecustEconsDayCurve;
import com.iesms.openservices.esmgmt.response.TmplHouseTypeVo;
import com.iesms.openservices.esmgmt.service.BenchmarkDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class BenchmarkDataServiceImpl extends AbstractIesmsBaseService implements BenchmarkDataService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private BenchmarkDataDao benchmarkDataDao;

    @Override
    public List<CeStatCecustEloadDayVo> getHistoricalCurve(CeHkBaseConfigHouseTypeVo ceHkBaseConfigHouseTypeVo) {
        return benchmarkDataDao.getHistoricalCurve(ceHkBaseConfigHouseTypeVo) ;
    }

    @Override
    public List<TmplHouseTypeVo> findTmTmplHouseType(TmplHouseTypeVo tmplHouseTypeVo) {
        return benchmarkDataDao.findTmTmplHouseType(tmplHouseTypeVo);
    }

    @Override
    public List<CeHkBaseConfigHouseTypeVo> findCeHkBaseConfigHouseType(CeHkBaseConfigHouseTypeVo CeHkBaseConfigHouseTypeVo, Pager pager) {
        return benchmarkDataDao. findCeHkBaseConfigHouseType(CeHkBaseConfigHouseTypeVo,pager);
    }

    @Override
    public Integer findCeHkBaseConfigHouseTypeNum(CeHkBaseConfigHouseTypeVo CeHkBaseConfigHouseTypeVo) {
        return benchmarkDataDao. findCeHkBaseConfigHouseTypeNum(CeHkBaseConfigHouseTypeVo);
    }

    @Override
    public Integer saveSetting(CeHkBaseConfigHouseTypeVo CeHkBaseConfigHouseTypeVo) {
        CeHkBaseConfigHouseTypeVo.setId(idGenerator.nextId());

        CeHkBaseConfigHouseTypeVo.setSortSn(1);
        CeHkBaseConfigHouseTypeVo.setGmtCreate(System.currentTimeMillis());
        CeHkBaseConfigHouseTypeVo.setGmtModified(System.currentTimeMillis());
        CeHkBaseConfigHouseTypeVo.setGmtInvalid(0);
        CeHkBaseConfigHouseTypeVo.setVersion(1);

        return benchmarkDataDao.saveSetting(CeHkBaseConfigHouseTypeVo);
    }

    @Override
    public Integer delSetting(String[] ids) {
        return benchmarkDataDao.delSetting(ids) ;
    }
}
