package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.EnergyAnalysisCreateReportDao;
import com.iesms.openservices.esmgmt.request.EnergyAnalysisAlreadyReportRequest;
import com.iesms.openservices.esmgmt.request.EnergyAnalysisCreateReportRequest;
import com.iesms.openservices.esmgmt.response.EnergyAnalysisCePartEconsMonthResponse;
import com.iesms.openservices.esmgmt.response.EnergyConsumptionTrendResponse;
import com.iesms.openservices.esmgmt.response.EnergySavingIncomeResponse;
import com.iesms.openservices.esmgmt.response.EnergyUnplannedEventsResponse;
import com.iesms.openservices.esmgmt.service.EnergyAnalysisCreateReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service
public class EnergyAnalysisCreateReportServiceImpl extends AbstractIesmsBaseService implements EnergyAnalysisCreateReportService{


    @Autowired
    private final EnergyAnalysisCreateReportDao energyAnalysisCreateReportDao;

    public EnergyAnalysisCreateReportServiceImpl(EnergyAnalysisCreateReportDao energyAnalysisCreateReportDao) {
        this.energyAnalysisCreateReportDao = energyAnalysisCreateReportDao;
    }


    @Override
    public int addEnergyAnalysisReport(EnergyAnalysisCreateReportRequest pojo) {
        pojo.setId(idGenerator.nextId());
        return energyAnalysisCreateReportDao.addEnergyAnalysisReport(pojo);
    }

    @Override
    public Map<String,Object> selCeCustByUnitId(EnergyAnalysisAlreadyReportRequest pojo) {
        Map<String, Object> map = new HashMap<>();
        if (pojo.getReportType().equals("5")) {
            map.put("resultList",energyAnalysisCreateReportDao.selCeCustYearByUnitId(pojo));
            map.put("total",energyAnalysisCreateReportDao.selCeCustYearByUnitIdTotal(pojo));
            return map;
        }else {
            map.put("resultList",energyAnalysisCreateReportDao.selCeCustMonthByUnitId(pojo));
            map.put("total",energyAnalysisCreateReportDao.selCeCustMonthByUnitIdTotal(pojo));
            return map;
        }
    }

    @Override
    public Map<String, Object> selCecntrByUnitId(EnergyAnalysisAlreadyReportRequest pojo) {
        Map<String, Object> map = new HashMap<>();
        if (pojo.getReportType().equals("5")) {
            map.put("resultList",energyAnalysisCreateReportDao.selCecntrYearByUnitId(pojo));
            map.put("total",energyAnalysisCreateReportDao.selCecntrYearByUnitIdTotal(pojo));
            return map;
        }else {
            map.put("resultList",energyAnalysisCreateReportDao.selCecntrMonthByUnitId(pojo));
            map.put("total",energyAnalysisCreateReportDao.selCecntrMonthByUnitIdTotal(pojo));
            return map;
        }
    }

    @Override
    public Map<String, Object> selCebsdByUnitId(EnergyAnalysisAlreadyReportRequest pojo) {
        Map<String, Object> map = new HashMap<>();
        if (pojo.getReportType().equals("5")) {
            map.put("resultList",energyAnalysisCreateReportDao.selCebsdYearByUnitId(pojo));
            map.put("total",energyAnalysisCreateReportDao.selCebsdYearByUnitIdTotal(pojo));
            return map;
        }else {
            map.put("resultList",energyAnalysisCreateReportDao.selCebsdMonthByUnitId(pojo));
            map.put("total",energyAnalysisCreateReportDao.selCebsdMonthByUnitIdTotal(pojo));
            return map;
        }
    }

    @Override
    public List<EnergyConsumptionTrendResponse> selConsumptionTrendDay(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selConsumptionTrendDay(pojo);
    }

    @Override
    public List<EnergyConsumptionTrendResponse> selConsumptionTrendMonth(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selConsumptionTrendMonth(pojo);
    }

    @Override
    public List<EnergyConsumptionTrendResponse> selConsumptionTrendYear(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selConsumptionTrendYear(pojo);
    }

    @Override
    public List<EnergySavingIncomeResponse> selSavingIncomeDay(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selSavingIncomeDay(pojo);
    }

    @Override
    public List<EnergySavingIncomeResponse> selSavingIncomeMonthOrYear(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selSavingIncomeMonthOrYear(pojo);
    }

    @Override
    public List<EnergyUnplannedEventsResponse> selUnplannedEventsAll(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selUnplannedEventsAll(pojo);
    }

    @Override
    public List<EnergyUnplannedEventsResponse> selUnplannedEventsProcessed(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selUnplannedEventsProcessed(pojo);
    }

    @Override
    public double selUnplannedEventsTotal(EnergyAnalysisAlreadyReportRequest pojo) {
        double allTotal = energyAnalysisCreateReportDao.selUnplannedEventsAllTotal(pojo);
        double processedTotal = energyAnalysisCreateReportDao.selUnplannedEventsProcessedTotal(pojo);
        double processed = 0;
        if (allTotal!=0.0 && processedTotal!=0.0) {
             processed =processedTotal / allTotal;
        }
        return processed;
    }

    @Override
    public double selUnplannedEventsAllTotal(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selUnplannedEventsAllTotal(pojo);
    }

    @Override
    public double selUnplannedEventsProcessedTotal(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selUnplannedEventsProcessedTotal(pojo);
    }

    @Override
    public String selProfitEsMgmt(EnergyAnalysisAlreadyReportRequest pojo) {
        return energyAnalysisCreateReportDao.selProfitEsMgmt(pojo);
    }

}





