package com.iesms.openservices.esmgmt.service.impl;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.EnergyOverviewOperatorDao;
import com.iesms.openservices.esmgmt.entity.*;
import com.iesms.openservices.esmgmt.request.OutPlanEventRequest;
import com.iesms.openservices.esmgmt.service.EnergyOverviewOperatorService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class EnergyOverviewOperatorServiceImpl extends AbstractIesmsBaseService implements EnergyOverviewOperatorService {
    private EnergyOverviewOperatorDao energyOverviewOperatorDao;
    public EnergyOverviewOperatorServiceImpl(EnergyOverviewOperatorDao energyOverviewOperatorDao) {
        this.energyOverviewOperatorDao = energyOverviewOperatorDao;
    }
    @Override
    public List<EsMgmtOutPlanEventVo> querySystemProcessedUser(OutPlanEventRequest request,String orgNo) {
        return energyOverviewOperatorDao.querySystemProcessedUser(request,orgNo);

    }
    @Override
    public int queryProcessedNum(OutPlanEventRequest request,String orgNo){
        return energyOverviewOperatorDao.queryProcessedNum(request,orgNo);
    }


    @Override
    public int queryNotProcessednum(OutPlanEventRequest request,String orgNo){
        return energyOverviewOperatorDao.queryNotProcessednum(request,orgNo);
    }

    @Override
    public EsMgmtOutPlanEventVo  queryresultWork(OutPlanEventRequest workRequest){
        return energyOverviewOperatorDao.queryresultWork(workRequest);
    }

    @Override
    public CeStatOrgEconsDayVo  getEconsDayElectricity(String orgNo){
        return energyOverviewOperatorDao.getEconsDayElectricity(orgNo);
    }

    @Override
    public  CeStatOrgEconsMonthVo getEconsMonthElectricity(CeStatOrgEconsMonthVo OrgEconsMonth,String orgNo){
        return energyOverviewOperatorDao.getEconsMonthElectricity( OrgEconsMonth,orgNo );
    }

    @Override
    public CeStatOrgEconsYearVo getEconsYearElectricity(CeStatOrgEconsYearVo OrgEconsYear, String orgNo){
        return energyOverviewOperatorDao.getEconsYearElectricity(OrgEconsYear ,orgNo);
    }

    @Override
    public CeStatOrgEconsDayVo getYesterdayEconsDayElectricity(String orgNo){
        return energyOverviewOperatorDao.getYesterdayEconsDayElectricity(orgNo);
    }

    @Override
    public CeStatOrgEconsMonthVo getlastMonthEconsMonthElectricity( CeStatOrgEconsMonthVo  OrgEconsMonthLast , String orgNo ){
        return energyOverviewOperatorDao.getlastMonthEconsMonthElectricity( OrgEconsMonthLast,orgNo);
    }

    @Override
    public CeStatOrgEconsYearVo  getLastYearEconsYearElectricity(CeStatOrgEconsYearVo  orgEconsYearLast, String orgNo){
        return energyOverviewOperatorDao.getLastYearEconsYearElectricity(orgEconsYearLast,orgNo);
    }

    @Override
    public CeStatOrgEloadDayVo  getCeStatOrgEloadDay(String orgNo){
        return energyOverviewOperatorDao.getCeStatOrgEloadDay(orgNo);
    }

    @Override
    public List<CeStatOrgEloadDayVo>  getCeStatOrgEloadMonth(String orgNo){
        return energyOverviewOperatorDao.getCeStatOrgEloadMonth(orgNo);
    }

    @Override
    public List<CeStatOrgEloadMonthVo>   getCeStatOrgEloadYear(String startYear,String endYear,String orgNo){
        return energyOverviewOperatorDao.getCeStatOrgEloadYear( startYear, endYear, orgNo );
    }

    @Override
    public CeStatOrgEloadDayVo getEloadMonthMaxValue(CeStatOrgEloadMonthVo EloadMonth,String orgNo){
        return energyOverviewOperatorDao.getEloadMonthMaxValue(EloadMonth,orgNo);
    }

    @Override
    public EsMgmtStatOrgMonthVo  getStatOrgMonthProfitEsMgmt(EsMgmtStatOrgMonthVo  StatOrgMonth,String orgNo ){
        return energyOverviewOperatorDao.getStatOrgMonthProfitEsMgmt(StatOrgMonth,orgNo);
    }

}





