package com.iesms.openservices.esmgmt.service.impl;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.ceresource.entity.CeGetCustVo;
import com.iesms.openservices.ceresource.request.CeCustRequest;
import com.iesms.openservices.esmgmt.dao.EnergyOverviewSingleuserDao;
import com.iesms.openservices.esmgmt.entity.*;
import com.iesms.openservices.esmgmt.request.OutPlanEventRequest;
import com.iesms.openservices.esmgmt.service.EnergyOverviewSingleuserService;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class EnergyOverviewSingleuserServiceImpl extends AbstractIesmsBaseService implements EnergyOverviewSingleuserService {
    private EnergyOverviewSingleuserDao energyOverviewSingleuserDao;
    public EnergyOverviewSingleuserServiceImpl(EnergyOverviewSingleuserDao energyOverviewSingleuserDao) {
        this.energyOverviewSingleuserDao = energyOverviewSingleuserDao;
    }

    @Override
    public CeGetCustVo getUserDetails(CeCustRequest CeCustRequest){
        return energyOverviewSingleuserDao.getUserDetails( CeCustRequest );
    }

    @Override
    public BigDecimal getProfitEsMgmt( CeCustRequest CeCustRequest) {
        return energyOverviewSingleuserDao.getProfitEsMgmt( CeCustRequest );
    }

    @Override
    public BigDecimal gettransformer( CeCustRequest CeCustRequest) {
        return energyOverviewSingleuserDao.gettransformer( CeCustRequest );
    }

    @Override
    public CeStatCecustEloadDayVo getStatCecustEloadDay(CeStatOrgEloadMonthVo EloadMonthRequest) {
        return energyOverviewSingleuserDao.getStatCecustEloadDay(EloadMonthRequest);
    }

    @Override
    public List<CeStatCecustEloadDayVo> getStatCecustEloadMonth(CeStatOrgEloadMonthVo EloadMonthRequest) {
        return energyOverviewSingleuserDao. getStatCecustEloadMonth(EloadMonthRequest);
    }

    @Override
    public List<CeStatCecustEloadMonthVo> getCeStatOrgEloadYear(String startYear,String endYear,Long id) {
        return energyOverviewSingleuserDao.getCeStatOrgEloadYear( startYear, endYear, id);
    }


    @Override
    public CeStatCecustEconsDayVo getCeStatCecustEconsDay(CeStatCecustEconsDayVo  CeStatCecustEconsDayRequest) {
        return energyOverviewSingleuserDao.getCeStatCecustEconsDay(CeStatCecustEconsDayRequest);
    }

    @Override
    public CeStatCecustEconsMonthVo getCeStatCecustEconsMonth(CeStatCecustEconsMonthVo  CeStatCecustEconsMonthRequest) {
        return energyOverviewSingleuserDao.getCeStatCecustEconsMonth(CeStatCecustEconsMonthRequest);
    }

    @Override
    public CeStatCecustEconsYearVo getCeStatCecustEconsYear(String startYear,String endYear,Long id) {
        return energyOverviewSingleuserDao.getCeStatCecustEconsYear(startYear, endYear, id);
    }

    @Override
    public  List<EsMgmtStatCecustDayVo>  getStatCecustMonth(EsMgmtStatCecustDayVo esMgmtStatCecustMonthRequest) {
        return energyOverviewSingleuserDao.getStatCecustMonth(esMgmtStatCecustMonthRequest);
    }

    @Override
    public   List<EsMgmtStatCecustMonthVo>   getStatCecustMonthYear(String startYear,String endYear,Long id){
        return energyOverviewSingleuserDao.getStatCecustMonthYear(startYear, endYear, id);
    }



    @Override
    public CeStatCecustEconsDayVo  getEconsDayElectricity(CeStatCecustEconsDayVo CecustEconsDay){
        return energyOverviewSingleuserDao.getEconsDayElectricity( CecustEconsDay);
    }

    @Override
    public  CeStatCecustEconsMonthVo getEconsMonthElectricity(CeStatCecustEconsMonthVo CecustEconsMonth){
        return energyOverviewSingleuserDao.getEconsMonthElectricity( CecustEconsMonth );
    }

    @Override
    public CeStatCecustEconsYearVo getEconsYearElectricity(CeStatCecustEconsYearVo CecustEconsYear){
        return energyOverviewSingleuserDao.getEconsYearElectricity(CecustEconsYear);
    }

    @Override
    public CeStatCecustEconsDayVo getYesterdayEconsDayElectricity(CeStatCecustEconsDayVo  CecustEconsDayLast){
        return energyOverviewSingleuserDao.getYesterdayEconsDayElectricity(CecustEconsDayLast);
    }

    @Override
    public CeStatCecustEconsMonthVo getlastMonthEconsMonthElectricity( CeStatCecustEconsMonthVo  CecustEconsMonthLast ){
        return energyOverviewSingleuserDao.getlastMonthEconsMonthElectricity( CecustEconsMonthLast);
    }

    @Override
    public CeStatCecustEconsYearVo  getLastYearEconsYearElectricity(CeStatCecustEconsYearVo  CecustEconsYearLast){
        return energyOverviewSingleuserDao.getLastYearEconsYearElectricity(CecustEconsYearLast);
    }

    @Override
    public List<EsMgmtOutPlanEventVo> querySystemProcessedUser(OutPlanEventRequest request) {
        return energyOverviewSingleuserDao.querySystemProcessedUser(request);
    }

}





