package com.iesms.openservices.esmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.EsMgmtOutPlanEventDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtOutPlanEventVo;
import com.iesms.openservices.esmgmt.entity.EsMgmtWorkorderDo;
import com.iesms.openservices.esmgmt.request.OutPlanEventRequest;
import com.iesms.openservices.esmgmt.response.SysUserVo;
import com.iesms.openservices.esmgmt.service.EsMgmtOutPlanEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import java.util.List;


@Service
public class EsMgmtOutPlanEventServiceImpl extends AbstractIesmsBaseService implements EsMgmtOutPlanEventService {
    private Logger logger= LoggerFactory.getLogger(getClass());

    private EsMgmtOutPlanEventDao outPlanEventDao;

    @Autowired
    public EsMgmtOutPlanEventServiceImpl(EsMgmtOutPlanEventDao outPlanEventDao){

        this.outPlanEventDao=outPlanEventDao;

    }

    @Override
    public List<EsMgmtOutPlanEventVo> getOutPlanEventInfo(OutPlanEventRequest request) {

        return outPlanEventDao.getOutPlanEventInfo(request);
    }


    @Override
    public List<EsMgmtOutPlanEventVo> getOutPlanEventInfoData(OutPlanEventRequest request, Pager page) {

        return outPlanEventDao.getOutPlanEventInfoData(request,page);
    }




    @Override
    public Integer getOutPlanEventInfoCountNum(OutPlanEventRequest request) {
        return outPlanEventDao.getOutPlanEventInfoCountNum(request);
    }

    @Override
    public int insertEsMgmtWorkorder(OutPlanEventRequest request){

        request.setGmtCreate(System.currentTimeMillis());
        return outPlanEventDao.insertEsMgmtWorkorder(request);
    }


    @Override
    public int updateOutPlanEventInfo(OutPlanEventRequest request) {
        logger.debug(">>>>>>> 操作时间 看看"+request.getHandleTime()+"<<<<<<<");
        return outPlanEventDao.updateOutPlanEventInfo(request);

    }

    @Override
    public List<EsMgmtWorkorderDo> getMgmtWorkorder(OutPlanEventRequest request){
        return outPlanEventDao.getMgmtWorkorder(request);

    }

    @Override
    public int deletePlanOutSide(OutPlanEventRequest request){
        return outPlanEventDao.deletePlanOutSide(request);

    }

    @Override
    public List<SysUserVo> getBySysUser(String deptNo) {
        return outPlanEventDao.getBySysUser(deptNo);
    }





}


