package com.iesms.openservices.esmgmt.service.impl;
import com.easesource.data.bean.Pager;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.ceresource.request.CeCustRequest;
import com.iesms.openservices.esmgmt.dao.EsMgmtOutPlanEventStatDao;
import com.iesms.openservices.esmgmt.entity.*;
import com.iesms.openservices.esmgmt.request.OutPlanEventRequest;
import com.iesms.openservices.esmgmt.response.*;
import com.iesms.openservices.esmgmt.service.EsMgmtOutPlanEventStatService;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class EsMgmtOutPlanEventStatServiceImpl extends AbstractIesmsBaseService implements EsMgmtOutPlanEventStatService {
    private EsMgmtOutPlanEventStatDao esMgmtOutPlanEventStatDao;

    public EsMgmtOutPlanEventStatServiceImpl(EsMgmtOutPlanEventStatDao esMgmtOutPlanEventStatDao) {
        this.esMgmtOutPlanEventStatDao = esMgmtOutPlanEventStatDao;
    }

    @Override
    public List<EsMgmtOutPlanEventStatVo> getOutPlanEventStat(EsMgmtOutPlanEventStatVo OutPlanEventStat,String orgNo){
        return esMgmtOutPlanEventStatDao.getOutPlanEventStat( OutPlanEventStat , orgNo);
    }

    @Override
    public List<EsMgmtOutPlanEventStatVo> getOutPlanEventStatData(EsMgmtOutPlanEventStatVo OutPlanEventStat,String orgNo, Pager page){
        return esMgmtOutPlanEventStatDao.getOutPlanEventStatData( OutPlanEventStat , orgNo,page);
    }


    @Override
    public List<EsMgmtOutPlanEventStatVo> getDataExport(EsMgmtOutPlanEventStatVo OutPlanEventStat,String orgNo){
        return esMgmtOutPlanEventStatDao.getDataExport( OutPlanEventStat , orgNo);
    }

    @Override
    public Integer getOutPlanEventStatNum(EsMgmtOutPlanEventStatVo OutPlanEventStat,String orgNo) {
        return esMgmtOutPlanEventStatDao.getOutPlanEventStatNum(OutPlanEventStat,orgNo);
    }

    @Override
    public List<CePointVo>   getCustAndPoint( Long  eventId){
        return esMgmtOutPlanEventStatDao. getCustAndPoint( eventId);
    }


    /** 管控收益报表 */

    /**  管控收益 用能单位 */
    @Override
    public List<EsMgmtStatOrgDay>   queryEsMgmtStatOrgDay(EsMgmtStatCepointDay request , Pager pager ){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatOrgDay(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatOrgDayNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatOrgDayNum(request );
    }
    @Override
    public List<EsMgmtStatOrgDay>   queryEsMgmtStatOrgDaySum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatOrgDaySum(request );
    }
    @Override
    public List<EsMgmtStatOrgMonth>   queryEsMgmtStatOrgMonth(EsMgmtStatCepointDay request , Pager pager ){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatOrgMonth(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatOrgMonthNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatOrgMonthNum(request );
    }
    @Override
    public List<EsMgmtStatOrgMonth>   queryEsMgmtStatOrgMonthSum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatOrgMonthSum(request );
    }



    /** 管控收益报用能客户 */
    @Override
    public List<EsMgmtStatCecustDay>   queryEsMgmtStatCecustDay(EsMgmtStatCepointDay request , Pager pager ){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustDay(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatCecustDayNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustDayNum(request );
    }
    @Override
    public List<EsMgmtStatCecustDay>   queryEsMgmtStatCecustDaySum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustDaySum(request );
    }



    @Override
    public List<EsMgmtStatCecustMonth>   queryEsMgmtStatCecustMonth(EsMgmtStatCepointDay request ,Pager pager){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustMonth(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatCecustMonthNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustMonthNum(request );
    }
    @Override
    public List<EsMgmtStatCecustMonth>   queryEsMgmtStatCecustMonthSum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustMonthSum(request );
    }


    @Override
    public List<EsMgmtStatCecustYear>   queryEsMgmtStatCecustYear(EsMgmtStatCepointDay request , Pager pager ){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustYear(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatCecustYearNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustYearNum(request );
    }
    @Override
    public List<EsMgmtStatCecustYear>   queryEsMgmtStatCecustYearSum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCecustYearSum(request );
    }






    /** 管控收益报用能点 */

    @Override
    public List<EsMgmtStatCepointDay>   queryEsMgmtStatCepointDay(EsMgmtStatCepointDay request ,Pager pager ){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCepointDay(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatCepointDayNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCepointDayNum(request );
    }



    @Override
    public List<EsMgmtStatCepointMonth>   queryEsMgmtStatCepointMonth(EsMgmtStatCepointDay request ,Pager pager){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCepointMonth(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatCepointMonthNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCepointMonthNum(request );
    }


    @Override
    public List<EsMgmtStatCepointYear>   queryEsMgmtStatCepointYear(EsMgmtStatCepointDay request ,Pager pager ){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCepointYear(request,pager );
    }
    @Override
    public Integer   queryEsMgmtStatCepointYearNum(EsMgmtStatCepointDay request){
        return esMgmtOutPlanEventStatDao. queryEsMgmtStatCepointYearNum(request );
    }





}





