package com.iesms.openservices.esmgmt.service.impl;
import com.easesource.data.bean.Pager;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.ceresource.entity.CeDeviceDo;
import com.iesms.openservices.ceresource.entity.CeGetCustVo;
import com.iesms.openservices.ceresource.request.CeCustRequest;
import com.iesms.openservices.esmgmt.dao.EsMgmtPlanningDao;
import com.iesms.openservices.esmgmt.entity.CePointVo;
import com.iesms.openservices.esmgmt.entity.EsMgmtPlanningDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtPlanningVo;
import com.iesms.openservices.esmgmt.request.MgmtPlanningRequest;
import com.iesms.openservices.esmgmt.request.PlanRequest;
import com.iesms.openservices.esmgmt.response.PlanVo;
import com.iesms.openservices.esmgmt.service.EsMgmtPlanningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class EsMgmtPlanningServiceImpl extends AbstractIesmsBaseService implements EsMgmtPlanningService {

    private EsMgmtPlanningDao esMgmtPlanningDao;

    @Autowired
    public EsMgmtPlanningServiceImpl(EsMgmtPlanningDao esMgmtPlanningDao){

        this.esMgmtPlanningDao=esMgmtPlanningDao;

    }


    @Override
    public List<EsMgmtPlanningVo> getMgmtPlaningData(MgmtPlanningRequest request) {

        return esMgmtPlanningDao.getMgmtPlaningData(request);

    }


    @Override
    public int insertMgmtPlanning(MgmtPlanningRequest request) {
        request.setGmtCreate(System.currentTimeMillis());
        request.setGmtModified(System.currentTimeMillis());
        return esMgmtPlanningDao.insertMgmtPlanning(request);

    }


    @Override
    public int deleteMgmtPlanning(MgmtPlanningRequest request) {
        return esMgmtPlanningDao.deleteMgmtPlanning(request);

    }


    @Override
    public int updateMgmtPlanning(MgmtPlanningRequest request) {
        return esMgmtPlanningDao.updateMgmtPlanning(request);

    }


    @Override
    public List<CePointVo> findCePoint(CeCustRequest request) {
        return esMgmtPlanningDao.findCePoint(request);

    }

    @Override
    public List<EsMgmtPlanningVo>  findMgmtPlanning(String  orgNo,Long cePointId ,String onoffTime){
        return esMgmtPlanningDao .findMgmtPlanning(orgNo, cePointId , onoffTime);
    }

    @Override
    public List<CePointVo>  findCePointVo( String orgNo ,Long  CeCustId){
        return esMgmtPlanningDao .findCePointVo(orgNo, CeCustId );
    }


    /**----------------------------   新------------------*/

    /** 查询用能计划 */
    @Override
    public List<PlanVo> getPlanData(PlanVo planVo , Pager page) {
        return esMgmtPlanningDao.getPlanData(planVo,page);
    }

    @Override
    public List<PlanVo> getPlanDataNumber(PlanVo planVo) {
        return esMgmtPlanningDao.getPlanDataNumber(planVo);
    }


    @Override
    public Integer getPlanDataNum(PlanVo planVo) {
        return esMgmtPlanningDao.getPlanDataNum(planVo);
    }



    /** 新增 用能计划 */
    @Override
    public int insertPlan(PlanRequest planRequest) {
        planRequest.setGmtCreate(System.currentTimeMillis());
        planRequest.setGmtModified(System.currentTimeMillis());
        return esMgmtPlanningDao.insertPlan(planRequest);

    }

    /**  根据相同的查询 */
    @Override
    public List<PlanVo> getPlanById(String planningName) {
        return esMgmtPlanningDao.getPlanById(planningName);
    }





    /**  根据用能点的ID 查询是否关联量测表记 */

    @Override
    public List<CePointVo> getPointById(CePointVo cePointVo) {
        return esMgmtPlanningDao.getPointById(cePointVo);
    }

    @Override
    public List<EsMgmtPlanningVo> findDevices(EsMgmtPlanningVo esMgmtPlanningVo) {
        return esMgmtPlanningDao.findDevices(esMgmtPlanningVo);
    }

    @Override
    public List<EsMgmtPlanningVo> findCustDevice(EsMgmtPlanningVo esMgmtPlanningVo) {
        return esMgmtPlanningDao.findCustDevice(esMgmtPlanningVo);
    }

    @Override
    public List<EsMgmtPlanningVo> getPointbyCustId(EsMgmtPlanningVo esMgmtPlanningVo) {
        return esMgmtPlanningDao.getPointbyCustId(esMgmtPlanningVo);
    }

    @Override
    public int newDeleteMgmtPlanning(String[] ids) {
        return esMgmtPlanningDao.newDeleteMgmtPlanning(ids);
    }


}


