package com.iesms.openservices.esmgmt.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cestat.dao.CePointDao;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCebsdClsCecustDayDao;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCebsdClsOrgDayDao;
import com.iesms.openservices.esmgmt.entity.*;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCebsdClsCecustDayService;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCebsdClsDistnrDayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author ghl
 */
@Service
public class EsMgmtStatCebsdClsCecustDayServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatCebsdClsCecustDayService {


    private final Logger logger = LoggerFactory.getLogger(EsMgmtStatCebsdClsCecustDayServiceImpl.class);

    @Autowired
    private EsMgmtStatCebsdClsCecustDayDao esMgmtStatCebsdClsCecustDayDao;

    @Autowired
    private CeResourceCommonDao ceResourceCommonDao;

    @Autowired
    private CePointDao cePointDao;

    @Autowired
    private EsMgmtStatCebsdClsOrgDayDao esMgmtStatCebsdClsOrgDayDao;

    @Autowired
    private EsMgmtStatCebsdClsDistnrDayService esMgmtStatCebsdClsDistnrDayService;

    @Override
    public void statCebsdClsEconsAndOrgValue(Map<String, String> map) {
        Map<String, String> distnrMap = new HashMap<>();
        distnrMap.put("dateStat", map.get("dateStat"));

        /**日数据统计**/
        List<String> orgNoList = ceResourceCommonDao.getOrgInfo();
        if (orgNoList != null && orgNoList.size() > 0) {
            for (String orgNo : orgNoList) {
                map.put("orgNo", orgNo);
                Map<String, String> orgMap = new HashMap<>();
                orgMap.put("orgNo", orgNo);
                orgMap.put("dateStat", map.get("dateStat"));

                // 根据系统单位查询客户
                List<String> custIdList = cePointDao.getCustIdByOrgNo(map);
                if (custIdList != null && custIdList.size() > 0) {
                    for (String ceCustId : custIdList) {
                        map.put("ceCustId", ceCustId);
                        // 按用能客户建筑空间设备分类
                        getClsEconsDataFromCepointEconsDay(map);
                        /*月,年数据统计*/
                        getCebsdClsEconsMonthAndYearValue(map);
                    }
                }

                // 按系统单位建筑空间设备分类
                getClsEconsDataFromCepointEconsDay(orgMap);
                /*月,年数据统计*/
                getCebsdClsOrgMonthAndYearValue(orgMap);
            }
        }

        // 社区资源建筑空间日统计
        esMgmtStatCebsdClsDistnrDayService.statCebsdClsEconsDistnrDayValue(map);
    }

    private void getClsEconsDataFromCepointEconsDay(Map<String, String> map) {

        List<EsMgmtStatCebsdClsCecustDayDo> cebsdClsCecustDayDoList = esMgmtStatCebsdClsCecustDayDao.getClsCecustDataFromCepointCecustDay(map);

        if (cebsdClsCecustDayDoList != null && cebsdClsCecustDayDoList.size() > 0) {
            if (map.containsKey("ceCustId")) {
                insertOrUpdateCeStatCebsdClsEsMgmtDayDo(cebsdClsCecustDayDoList);
            } else {
                insertOrUpdateCeStatCebsdClsOrgDayDo(cebsdClsCecustDayDoList);
            }
        }
    }

    /**
     * @Author: ghl
     * @Description: 月数据统计查询
     * @Date: 2020/3/4 10:04
     * @Param: [map]
     * @return: java.util.List<com.iesms.openservices.cestat.entity.CeStatCebsdClsEconsMonthDo>
     **/
    private void getCebsdClsEconsMonthAndYearValue(Map<String, String> map) {

        List<EsMgmtStatCebsdClsCecustMonthDo> clsCecustMonthDoList = esMgmtStatCebsdClsCecustDayDao.getCebsdClsCecustMonth(map);
        if (clsCecustMonthDoList != null && clsCecustMonthDoList.size() > 0) {
            insertOrUpdateCeStatCebsdClsEsMgmtMonthDo(clsCecustMonthDoList);
        }

        List<EsMgmtStatCebsdClsCecustYearDo> clsCecustYearDoList = esMgmtStatCebsdClsCecustDayDao.getCebsdClsCecustYear(map);
        if (clsCecustYearDoList != null && clsCecustYearDoList.size() > 0) {
            insertOrUpdateCeStatCebsdClsEsMgmtYearDo(clsCecustYearDoList);
        }
    }

    /**
     * @Author: ghl
     * @Description: 年数据统计查询
     * @Date: 2020/3/4 11:12
     * @Param: [map]
     * @return: java.util.List<com.iesms.openservices.cestat.entity.CeStatCebsdClsEconsYearDo>
     **/
    private void getCebsdClsOrgMonthAndYearValue(Map<String, String> map) {

        List<EsMgmtStatCebsdClsOrgMonthDo> cebsdClsOrgMonthDoList = esMgmtStatCebsdClsOrgDayDao.getCebsdClsOrgMonth(map);
        if (cebsdClsOrgMonthDoList != null && cebsdClsOrgMonthDoList.size() > 0) {
            insertOrUpdateCeStatCebsdClsOrgMonthDo(cebsdClsOrgMonthDoList);
        }

        List<EsMgmtStatCebsdClsOrgYearDo> cebsdClsOrgYearDoList = esMgmtStatCebsdClsOrgDayDao.getCebsdClsOrgYear(map);
        if (cebsdClsOrgYearDoList != null && cebsdClsOrgYearDoList.size() > 0) {
            insertOrUpdateCeStatCebsdClsOrgYearDo(cebsdClsOrgYearDoList);
        }
    }

    @Override
    public void insertOrUpdateCeStatCebsdClsEsMgmtDayDo(List<EsMgmtStatCebsdClsCecustDayDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cebsdClsCecustDayDo -> {
                cebsdClsCecustDayDo.setId(idGenerator.nextId());
                cebsdClsCecustDayDo.setGmtCreate(System.currentTimeMillis());
                cebsdClsCecustDayDo.setGmtModified(System.currentTimeMillis());
                cebsdClsCecustDayDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateCeStatCebsdClsEsMgmtDayDo value======:{}", JsonConvertUtils.convertToString(list));
            }
            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCebsdClsCecustDayDao.insertOrUpdateEsMgmtStatCebsdClsCecustDayDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateCeStatCebsdClsEsMgmtDayDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateCeStatCebsdClsEsMgmtMonthDo(List<EsMgmtStatCebsdClsCecustMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cebsdClsCecustMonthDo -> {
                cebsdClsCecustMonthDo.setId(idGenerator.nextId());
                cebsdClsCecustMonthDo.setGmtCreate(System.currentTimeMillis());
                cebsdClsCecustMonthDo.setGmtModified(System.currentTimeMillis());
                cebsdClsCecustMonthDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateCeStatCebsdClsEsMgmtMonthDo value======:{}", JsonConvertUtils.convertToString(list));
            }
            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCebsdClsCecustDayDao.insertOrUpdateEsMgmtStatCebsdClsCecustMonthDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateCeStatCebsdClsEsMgmtMonthDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateCeStatCebsdClsEsMgmtYearDo(List<EsMgmtStatCebsdClsCecustYearDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cebsdClsCecustYearDo -> {
                cebsdClsCecustYearDo.setId(idGenerator.nextId());
                cebsdClsCecustYearDo.setGmtCreate(System.currentTimeMillis());
                cebsdClsCecustYearDo.setGmtModified(System.currentTimeMillis());
                cebsdClsCecustYearDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateCeStatCebsdClsEsMgmtYearDo value======:{}", JsonConvertUtils.convertToString(list));
            }
            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCebsdClsCecustDayDao.insertOrUpdateEsMgmtStatCebsdClsCecustYearDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateCeStatCebsdClsEsMgmtYearDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateCeStatCebsdClsOrgDayDo(List<EsMgmtStatCebsdClsCecustDayDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cebsdClsCecustYearDo -> {
                cebsdClsCecustYearDo.setId(idGenerator.nextId());
                cebsdClsCecustYearDo.setGmtCreate(System.currentTimeMillis());
                cebsdClsCecustYearDo.setGmtModified(System.currentTimeMillis());
                cebsdClsCecustYearDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateCeStatCebsdClsOrgDayDo value======:{}", JsonConvertUtils.convertToString(list));
            }
            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCebsdClsOrgDayDao.insertOrUpdateEsMgmtStatCebsdClsOrgDayDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateCeStatCebsdClsOrgDayDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateCeStatCebsdClsOrgMonthDo(List<EsMgmtStatCebsdClsOrgMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cebsdClsOrgMonthDo -> {
                cebsdClsOrgMonthDo.setId(idGenerator.nextId());
                cebsdClsOrgMonthDo.setGmtCreate(System.currentTimeMillis());
                cebsdClsOrgMonthDo.setGmtModified(System.currentTimeMillis());
                cebsdClsOrgMonthDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateCeStatCebsdClsOrgMonthDo value======:{}", JsonConvertUtils.convertToString(list));
            }
            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCebsdClsOrgDayDao.insertOrUpdateEsMgmtStatCebsdClsOrgMonthDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateCeStatCebsdClsOrgMonthDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateCeStatCebsdClsOrgYearDo(List<EsMgmtStatCebsdClsOrgYearDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cebsdClsOrgYearDo -> {
                cebsdClsOrgYearDo.setId(idGenerator.nextId());
                cebsdClsOrgYearDo.setGmtCreate(System.currentTimeMillis());
                cebsdClsOrgYearDo.setGmtModified(System.currentTimeMillis());
                cebsdClsOrgYearDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateCeStatCebsdClsOrgYearDo value======:{}", JsonConvertUtils.convertToString(list));
            }
            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCebsdClsOrgDayDao.insertOrUpdateEsMgmtStatCebsdClsOrgYearDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateCeStatCebsdClsOrgYearDo error: {}---", e.getMessage());
                }
            }
        }
    }
}
