package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.cestat.dao.CeStatDistnrEloadDao;
import com.iesms.openservices.cestat.entity.DistNeighborhoodResourceValueDo;
import com.iesms.openservices.cestat.util.ValueUtil;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCebsdClsDistnrDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCebsdClsDistnrDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCebsdClsDistnrMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCebsdClsDistnrYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCebsdClsDistnrDayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author ghl
 * 管理节能日统计（按社区资源建筑空间设备分类）
 */
@Service
public class EsMgmtStatCebsdClsDistnrDayServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatCebsdClsDistnrDayService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private EsMgmtStatCebsdClsDistnrDayDao esMgmtStatCebsdClsDistnrDayDao;

    @Resource
    private CeResourceCommonDao ceResourceCommonDao;

    @Resource
    private CeStatDistnrEloadDao distnrEloadDao;

    @Override
    public void statCebsdClsEconsDistnrDayValue(Map<String, String> map) {
        if (logger.isDebugEnabled()) {
            logger.debug("====== start statCebsdClsEconsDistnrDayValue ======");
        }


        List<String> resourceIdList = distnrEloadDao.getDistNeighborhoodResourceId();

        List<String> idList = null;
        List<EsMgmtStatCebsdClsDistnrDayDo> esMgmtStatCebsdClsDistnrDayDoList = new ArrayList<>();
        if (resourceIdList != null && resourceIdList.size() > 0) {
            for (String resourceId : resourceIdList) {

                // 查询资源信息
                DistNeighborhoodResourceValueDo resourceValueDo = distnrEloadDao.getDistNeighborhoodInfo(resourceId);

                List<EsMgmtStatCebsdClsDistnrDayDo> selectList = null;
                Map<String, String> map1 = new HashMap<>();
                int type = resourceValueDo.getDistNeighborhoodResourceType();


                Map<String, Object> stringMap = new HashMap<>();
                List<DistNeighborhoodResourceValueDo> list = null;

                switch (type) {
                    case 1:
                        map1.put("type", "1");
                        map1.put("distNeighborhoodId", resourceValueDo.getDistNeighborhoodId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("resourceIds", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        selectList = esMgmtStatCebsdClsDistnrDayDao.getCeStatDistnrcebsdDaySum(stringMap);
                        if (selectList != null && selectList.size() > 0) {
                            selectList.removeIf(Objects::isNull);
                            for (EsMgmtStatCebsdClsDistnrDayDo cebsdClsEconsDistnrDayDo : selectList) {
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistNeighborhoodId());
                                esMgmtStatCebsdClsDistnrDayDoList.add(cebsdClsEconsDistnrDayDo);
                            }
                        }
                        break;
                    case 2:
                        map1.put("type", "2");
                        map1.put("distBuildingId", resourceValueDo.getDistBuildingId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("distNeighborhoodResourceId", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        selectList = esMgmtStatCebsdClsDistnrDayDao.getCeStatDistnrcebsdDaySum(stringMap);
                        if (selectList != null && selectList.size() > 0) {
                            selectList.removeIf(Objects::isNull);
                            for (EsMgmtStatCebsdClsDistnrDayDo cebsdClsEconsDistnrDayDo : selectList) {
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistBuildingId());
                                esMgmtStatCebsdClsDistnrDayDoList.add(cebsdClsEconsDistnrDayDo);
                            }
                        }
                        break;
                    case 3:
                        map1.put("type", "3");
                        map1.put("distBuildingUnitId", resourceValueDo.getDistBuildingUnitId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("distNeighborhoodResourceId", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        selectList = esMgmtStatCebsdClsDistnrDayDao.getCeStatDistnrcebsdDaySum(stringMap);
                        if (selectList != null && selectList.size() > 0) {
                            selectList.removeIf(Objects::isNull);
                            for (EsMgmtStatCebsdClsDistnrDayDo cebsdClsEconsDistnrDayDo : selectList) {
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistBuildingUnitId());
                                esMgmtStatCebsdClsDistnrDayDoList.add(cebsdClsEconsDistnrDayDo);
                            }
                        }
                        break;
                    case 4:
                        map1.put("type", "4");
                        map1.put("distBuildingFloorId", resourceValueDo.getDistBuildingFloorId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("distNeighborhoodResourceId", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        selectList = esMgmtStatCebsdClsDistnrDayDao.getCeStatDistnrcebsdDaySum(stringMap);
                        if (selectList != null && selectList.size() > 0) {
                            esMgmtStatCebsdClsDistnrDayDoList.removeIf(Objects::isNull);
                            for (EsMgmtStatCebsdClsDistnrDayDo cebsdClsEconsDistnrDayDo : selectList) {
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                                cebsdClsEconsDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistBuildingFloorId());
                                esMgmtStatCebsdClsDistnrDayDoList.add(cebsdClsEconsDistnrDayDo);
                            }
                        }
                        break;
                    default:
                        break;
                }
            }

            // 日数据统计 ceStatCebsdClsEconsDay
            if (esMgmtStatCebsdClsDistnrDayDoList != null && esMgmtStatCebsdClsDistnrDayDoList.size() > 0) {
                insertOrUpdateCebsdClsEconsDistnrDay(esMgmtStatCebsdClsDistnrDayDoList);
            }

            // 月年数据统计
            Map<String, String> stringMap = new HashMap<>();
            stringMap.put("dateStat", map.get("dateStat"));

            statCebsdClsEconsDistnrMonthAndYearValue(stringMap);
        }

    }

    private void statCebsdClsEconsDistnrMonthAndYearValue(Map<String, String> map) {

        // 月数据统计
        List<EsMgmtStatCebsdClsDistnrMonthDo> clsDistnrMonthDoList = esMgmtStatCebsdClsDistnrDayDao.selectEsMgmtStatCebsdClsDistnrMonthValue(map);
        if (clsDistnrMonthDoList != null && clsDistnrMonthDoList.size() > 0) {
            insertOrUpdateCebsdClsEconsDistnrMonth(clsDistnrMonthDoList);
        }

        // 年数据统计
        List<EsMgmtStatCebsdClsDistnrYearDo> clsDistnrYearDoList = esMgmtStatCebsdClsDistnrDayDao.selectEsMgmtStatCebsdClsDistnrYearValue(map);
        if (clsDistnrYearDoList != null && clsDistnrYearDoList.size() > 0) {
            insertOrUpdateCebsdClsEconsDistnrYear(clsDistnrYearDoList);
        }
    }

    /**
     * 日数据插入
     *
     * @param esMgmtStatCebsdClsDistnrDayDoList
     */
    private void insertOrUpdateCebsdClsEconsDistnrDay(List<EsMgmtStatCebsdClsDistnrDayDo> esMgmtStatCebsdClsDistnrDayDoList) {
        try {
            esMgmtStatCebsdClsDistnrDayDoList.forEach(d -> {
                d.setId(idGenerator.nextId());
                d.setGmtCreate(System.currentTimeMillis());
                d.setGmtModified(System.currentTimeMillis());
                d.setVersion(1);
            });

            esMgmtStatCebsdClsDistnrDayDao.insertOrUpdatecebsdDistnrDay(esMgmtStatCebsdClsDistnrDayDoList);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateCebsdClsEconsDistnrDay error: " + e.getLocalizedMessage());
        }
    }

    /**
     * 月数据插入
     *
     * @param distnrMonthDoList
     */
    private void insertOrUpdateCebsdClsEconsDistnrMonth(List<EsMgmtStatCebsdClsDistnrMonthDo> distnrMonthDoList) {
        try {
            distnrMonthDoList.forEach(d -> {
                d.setId(idGenerator.nextId());
                d.setGmtCreate(System.currentTimeMillis());
                d.setGmtModified(System.currentTimeMillis());
                d.setVersion(1);
            });

            esMgmtStatCebsdClsDistnrDayDao.insertOrUpdatecebsdDistnrMonth(distnrMonthDoList);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateCebsdClsEconsDistnrMonth error: " + e.getLocalizedMessage());
        }
    }

    /**
     * 年数据插入
     *
     * @param distnrYearDoList
     */
    private void insertOrUpdateCebsdClsEconsDistnrYear(List<EsMgmtStatCebsdClsDistnrYearDo> distnrYearDoList) {
        try {
            distnrYearDoList.forEach(d -> {
                d.setId(idGenerator.nextId());
                d.setGmtCreate(System.currentTimeMillis());
                d.setGmtModified(System.currentTimeMillis());
                d.setVersion(1);
            });

            esMgmtStatCebsdClsDistnrDayDao.insertOrUpdatecebsdDistnrYear(distnrYearDoList);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateCebsdClsEconsDistnrYear error: " + e.getLocalizedMessage());
        }
    }
}
