package com.iesms.openservices.esmgmt.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.ceresource.entity.CeContainerDo;
import com.iesms.openservices.cestat.dao.CePointDao;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCecntrDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCecntrDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCecntrMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCecntrYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCecntrDayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author ghl
 */
@Service
public class EsMgmtStatCecntrDayServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatCecntrDayService {


    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private EsMgmtStatCecntrDayDao esMgmtStatCecntrDayDao;
    @Autowired
    private CeResourceCommonDao ceResourceCommonDao;
    @Autowired
    private CePointDao cePointDao;

    @Override
    public void statCebsdCecntrEsMgmtValue(Map<String, String> map) {
        /**日数据统计 楼层：BUILDING_FLOOR 房间：BUILDING_ROOM**/
        List<String> orgNoList = ceResourceCommonDao.getOrgInfo();
        if (orgNoList != null && orgNoList.size() > 0) {
            for (String orgNo : orgNoList) {
                map.put("orgNo", orgNo);
                // 根据系统单位查询客户
                List<String> custIdList = cePointDao.getCustIdByOrgNo(map);
                if (custIdList == null || custIdList.size() < 1) {
                    continue;
                }
                for (String ceCustId : custIdList) {
                    map.put("ceCustId", ceCustId);
                    // 查询容器id
                    List<CeContainerDo> ceContainerDoList = esMgmtStatCecntrDayDao.getCeContainerIdByOrgNoAndCuestId(map);
                    if (ceContainerDoList == null || ceContainerDoList.size() < 1) {
                        continue;
                    }
                    // 日统计
                    getCebsdCecntrEsMgmtValue(map, ceContainerDoList);

                }
            }
        }
    }

    private void getCebsdCecntrEsMgmtValue(Map<String, String> map, List<CeContainerDo> ceContainerDoList) {

        for (CeContainerDo ceContainerDo : ceContainerDoList) {
            map.put("ceCntrId", String.valueOf(ceContainerDo.getId()));
            // 先查询容器是否有用能点(总表）数据
            List<EsMgmtStatCecntrDayDo> cecntrDayDoList = esMgmtStatCecntrDayDao.getCecntrcebsdDayValueByPoint(map);

            if (cecntrDayDoList != null && cecntrDayDoList.size() > 0) {
                // 容器有总表数据
                insertOrUpdateEsMgmtStatCecntrDayDo(cecntrDayDoList);
            } else {
                // 容器没有总表数据，查询容器下面所有设备数据
                List<EsMgmtStatCecntrDayDo> mgmtStatCecntrDayDoList = esMgmtStatCecntrDayDao.getCecntrcebsdDayValueByDevice(map);
                if (mgmtStatCecntrDayDoList != null && mgmtStatCecntrDayDoList.size() > 0) {
                    insertOrUpdateEsMgmtStatCecntrDayDo(mgmtStatCecntrDayDoList);
                }
            }

            //月统计
            List<EsMgmtStatCecntrMonthDo> statCecntrMonthDoList = esMgmtStatCecntrDayDao.getCecntrcebsdMonthValue(map);
            if (statCecntrMonthDoList != null && statCecntrMonthDoList.size() > 0) {
                insertOrUpdateEsMgmtStatCecntrMonthDo(statCecntrMonthDoList);
            }
            // 年统计
            List<EsMgmtStatCecntrYearDo> statCecntrYearDoList = esMgmtStatCecntrDayDao.getCecntrcebsdYearValue(map);
            if (statCecntrYearDoList != null && statCecntrYearDoList.size() > 0) {
                insertOrUpdateEsMgmtStatCecntrYearDo(statCecntrYearDoList);
            }
        }
    }

    @Override
    public void insertOrUpdateEsMgmtStatCecntrDayDo(List<EsMgmtStatCecntrDayDo> list) {

        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(esMgmtStatCecntrDayDo -> {
                esMgmtStatCecntrDayDo.setId(idGenerator.nextId());
                esMgmtStatCecntrDayDo.setGmtCreate(System.currentTimeMillis());
                esMgmtStatCecntrDayDo.setGmtModified(System.currentTimeMillis());
                esMgmtStatCecntrDayDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateEsMgmtStatCecntrDayDo value======:{}", JsonConvertUtils.convertToString(list));
            }

            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCecntrDayDao.insertOrUpdateEsMgmtStatCecntrDayDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateEsMgmtStatCecntrDayDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateEsMgmtStatCecntrMonthDo(List<EsMgmtStatCecntrMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(esMgmtStatCecntrMonthDo -> {
                esMgmtStatCecntrMonthDo.setId(idGenerator.nextId());
                esMgmtStatCecntrMonthDo.setGmtCreate(System.currentTimeMillis());
                esMgmtStatCecntrMonthDo.setGmtModified(System.currentTimeMillis());
                esMgmtStatCecntrMonthDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateEsMgmtStatCecntrMonthDo value======:{}", JsonConvertUtils.convertToString(list));
            }

            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCecntrDayDao.insertOrUpdateEsMgmtStatCecntrMonthDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateEsMgmtStatCecntrMonthDo error: {}---", e.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateEsMgmtStatCecntrYearDo(List<EsMgmtStatCecntrYearDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(esMgmtStatCecntrYearDo -> {
                esMgmtStatCecntrYearDo.setId(idGenerator.nextId());
                esMgmtStatCecntrYearDo.setGmtCreate(System.currentTimeMillis());
                esMgmtStatCecntrYearDo.setGmtModified(System.currentTimeMillis());
                esMgmtStatCecntrYearDo.setVersion(1);
            });

            if (logger.isDebugEnabled()) {
                logger.debug("====insertOrUpdateEsMgmtStatCecntrYearDo value======:{}", JsonConvertUtils.convertToString(list));
            }

            if (list != null && list.size() > 0) {
                try {
                    esMgmtStatCecntrDayDao.insertOrUpdateEsMgmtStatCecntrYearDo(list);
                } catch (Exception e) {
                    logger.error("---insertOrUpdateEsMgmtStatCecntrYearDo error: {}---", e.getMessage());
                }
            }
        }
    }
}
