package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.ceresource.entity.CeDeviceDo;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCedeviceDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCedeviceDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCedeviceMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCedeviceYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCedeviceDayService;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.javassist.bytecode.CodeAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
@Slf4j
public class EsMgmtStatCedeviceDayServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatCedeviceDayService {

    @Autowired
    private EsMgmtStatCedeviceDayDao cedeviceDayDao;

    @Override
    public void ceEsMgmtStatCedevice(Map<String, String> map) {
// 查询设备信息
        List<CeDeviceDo> deviceIdList = cedeviceDayDao.getCeDeviceIdsAndCustIds();
        if (deviceIdList == null || deviceIdList.size() < 1) {
            return;
        }
        deviceIdList.removeIf(Objects::isNull);
        Map<Long, List<CeDeviceDo>> listMap = deviceIdList.stream().collect(Collectors.groupingBy(CeDeviceDo::getCeCustId));
        for (List<CeDeviceDo> list : listMap.values()) {
            if (list == null) {
                continue;
            }
            list.removeIf(Objects::isNull);
            if (list.size() < 1) {
                continue;
            }
            List<EsMgmtStatCedeviceDayDo> inserDaytList = new ArrayList<>();
            for (CeDeviceDo ceDeviceDo : list) {
                String deviceId = String.valueOf(ceDeviceDo.getId());
                map.put("deviceId",deviceId);
                EsMgmtStatCedeviceDayDo cedeviceDayDo = cedeviceDayDao.getgetEsMgmtStatCedeviceDay(map);
                if (cedeviceDayDo == null) {
                    // 如果设备数据为空，则查询设备下面所有子设备的数据和
                    map.put("deviceParentId",deviceId);
                    List<String> ceDeviceIds = cedeviceDayDao.getDeviceIdsByParentId(map);
                    if (ceDeviceIds == null) {
                        continue;
                    }
                    ceDeviceIds.removeIf(Objects::isNull);
                    if (ceDeviceIds.size() < 1) {
                        continue;
                    }
                    map.put("ceDeviceIds",deviceId);
                    // 查询设备下面所有子设备的数据和
                    EsMgmtStatCedeviceDayDo cedeviceSum = cedeviceDayDao.getEsMgmtStatCedeviceSum(map);
                    if (cedeviceSum == null) {
                        continue;
                    }
                    inserDaytList.add(cedeviceSum);
                }
                inserDaytList.add(cedeviceDayDo);
            }
            insertOrUpdateCeStatCedeviceEsMgmtDay(inserDaytList);
        }

        // 设备月年统计
        insertOrUpdateMonthAndYear(map);
    }

    private void insertOrUpdateMonthAndYear(Map<String, String> map) {
        List<EsMgmtStatCedeviceMonthDo> cedeviceMonthDoList = cedeviceDayDao.getEsMgmtStatCedeviceMonth(map);
        insertOrUpdateCeStatCedeviceEsMgmtMonth(cedeviceMonthDoList);

        List<EsMgmtStatCedeviceYearDo> yearDoList = cedeviceDayDao.getEsMgmtStatCedeviceYear(map);
        insertOrUpdateCeStatCedeviceEsMgmtYear(yearDoList);
    }

    private void insertOrUpdateCeStatCedeviceEsMgmtDay(List<EsMgmtStatCedeviceDayDo> list) {
        if (list != null && list.size() > 0) {
            list.forEach(cedeviceDayDao -> {
                cedeviceDayDao.setId(idGenerator.nextId());
                cedeviceDayDao.setGmtCreate(System.currentTimeMillis());
                cedeviceDayDao.setGmtModified(System.currentTimeMillis());
                cedeviceDayDao.setVersion(1);
            });

            try {
                cedeviceDayDao.insertOrUpdateEsMgmtStatCedeviceDay(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateCeStatCedeviceEsMgmtDay error:{}", e.getMessage());
            }
        }
    }

    private void insertOrUpdateCeStatCedeviceEsMgmtMonth(List<EsMgmtStatCedeviceMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.forEach(cedeviceEsMgmtMonthDo -> {
                cedeviceEsMgmtMonthDo.setId(idGenerator.nextId());
                cedeviceEsMgmtMonthDo.setGmtCreate(System.currentTimeMillis());
                cedeviceEsMgmtMonthDo.setGmtModified(System.currentTimeMillis());
                cedeviceEsMgmtMonthDo.setVersion(1);
            });
            try {
                cedeviceDayDao.insertOrUpdateEsMgmtStatCedeviceMonth(list);
            } catch (CodeAttribute.RuntimeCopyException e) {
                log.error("insertOrUpdateCeStatCedeviceEsMgmtMonth error:{}", e.getMessage());
            }
        }
    }

    private void insertOrUpdateCeStatCedeviceEsMgmtYear(List<EsMgmtStatCedeviceYearDo> list) {
        if (list != null && list.size() > 0) {
            list.forEach(cedeviceEsMgmtYearDo -> {
                cedeviceEsMgmtYearDo.setId(idGenerator.nextId());
                cedeviceEsMgmtYearDo.setGmtCreate(System.currentTimeMillis());
                cedeviceEsMgmtYearDo.setGmtModified(System.currentTimeMillis());
                cedeviceEsMgmtYearDo.setVersion(1);
            });
            try {
                cedeviceDayDao.insertOrUpdateEsMgmtStatCedeviceYear(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateCeStatCedeviceEsMgmtYear error:{}", e.getMessage());
            }
        }
    }
}
