package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCepartDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCepartDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCepartMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCepartYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCepartDayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
public class EsMgmtStatCepartDayServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatCepartDayService {

    @Resource
    private EsMgmtStatCepartDayDao cepartDayDao;

    @Override
    public void statEsMgmtStatCepartValue(Map<String, String> map) {
        List<EsMgmtStatCepartDayDo> cepartEloadDayDoList = cepartDayDao.getEsMgmtStatCepartValueByDevice(map);
        insertOrUpdateEsMgmtStatCepartDay(cepartEloadDayDoList);

        List<EsMgmtStatCepartMonthDo> monthDoList = cepartDayDao.getEsMgmtCepartMonthValue(map);

        insertOrUpdateEsMgmtStatCepartMonth(monthDoList);

        List<EsMgmtStatCepartYearDo> yearDoList = cepartDayDao.getEsMgmtCepartYearValue(map);

        insertOrUpdateEsMgmtStatCepartYear(yearDoList);
    }


    private void insertOrUpdateEsMgmtStatCepartDay(List<EsMgmtStatCepartDayDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(CcpartEloadDayDo -> {
                CcpartEloadDayDo.setId(idGenerator.nextId());
                CcpartEloadDayDo.setGmtCreate(System.currentTimeMillis());
                CcpartEloadDayDo.setGmtModified(System.currentTimeMillis());
                CcpartEloadDayDo.setVersion(1);
            });
            try {
                cepartDayDao.insertOrUpdateCeEsMgmtStatCepartDay(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatCepartDay error:{}", e.getMessage());
            }
        }
    }

    private void insertOrUpdateEsMgmtStatCepartMonth(List<EsMgmtStatCepartMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cepartEloadMonthDo -> {
                cepartEloadMonthDo.setId(idGenerator.nextId());
                cepartEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                cepartEloadMonthDo.setGmtModified(System.currentTimeMillis());
                cepartEloadMonthDo.setVersion(1);
            });

            try {
                cepartDayDao.insertOrUpdateCeEsMgmtStatCepartMonth(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatCepartMonth error:{}", e.getMessage());
            }
        }
    }

    private void insertOrUpdateEsMgmtStatCepartYear(List<EsMgmtStatCepartYearDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cepartEloadYearDo -> {
                cepartEloadYearDo.setId(idGenerator.nextId());
                cepartEloadYearDo.setGmtCreate(System.currentTimeMillis());
                cepartEloadYearDo.setGmtModified(System.currentTimeMillis());
                cepartEloadYearDo.setVersion(1);
            });

            try {
                cepartDayDao.insertOrUpdateCeEsMgmtStatCepartYear(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatCepartYear error:{}", e.getMessage());
            }
        }
    }

}
