package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cestat.dao.CeStatDistnrEloadDao;
import com.iesms.openservices.cestat.entity.DistNeighborhoodResourceValueDo;
import com.iesms.openservices.cestat.util.ValueUtil;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatDistnrDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatDistnrDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatDistnrMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatDistnrYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatDistnrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class EsMgmtStatDistnrServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatDistnrService {

    @Resource
    private EsMgmtStatDistnrDao esMgmtStatDistnrDao;


    @Resource
    private CeStatDistnrEloadDao distnrEloadDao;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 管理节能数据统计（按社区资源）
     *
     * @param map
     * @return esMgmtStatCecustDay
     */
    @Override
    public void statEsMgmtStatDistnrDayValue(Map<String, String> map) {

        if (logger.isDebugEnabled()) {
            logger.debug("=== statEsMgmtStatDistnrDayValue start ===");
        }


        List<String> resourceIdList = distnrEloadDao.getDistNeighborhoodResourceId();
        List<EsMgmtStatDistnrDayDo> distnrDayDoList = new ArrayList<>();
        List<String> idList = null;
        EsMgmtStatDistnrDayDo esMgmtStatDistnrDayDo = null;
        if (resourceIdList != null && resourceIdList.size() > 0) {
            for (String resourceId : resourceIdList) {
                // 查询资源信息
                DistNeighborhoodResourceValueDo resourceValueDo = distnrEloadDao.getDistNeighborhoodInfo(resourceId);

                Map<String, String> map1 = new HashMap<>();
                int type = resourceValueDo.getDistNeighborhoodResourceType();

                Map<String, Object> stringMap = new HashMap<>();
                List<DistNeighborhoodResourceValueDo> list = null;

                switch (type) {
                    case 1:
                        map1.put("type", "1");
                        map1.put("distNeighborhoodId", resourceValueDo.getDistNeighborhoodId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("resourceIds", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        esMgmtStatDistnrDayDo = esMgmtStatDistnrDao.getesMgmtStatDistnrDaySum(stringMap);
                        if (esMgmtStatDistnrDayDo != null) {
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistNeighborhoodId());
                            distnrDayDoList.add(esMgmtStatDistnrDayDo);
                        }
                        break;
                    case 2:

                        map1.put("type", "2");
                        map1.put("distBuildingId", resourceValueDo.getDistBuildingId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("distNeighborhoodResourceId", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        esMgmtStatDistnrDayDo = esMgmtStatDistnrDao.getesMgmtStatDistnrDaySum(stringMap);
                        if (esMgmtStatDistnrDayDo != null) {
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistBuildingId());
                            distnrDayDoList.add(esMgmtStatDistnrDayDo);
                        }
                        break;
                    case 3:
                        map1.put("type", "3");
                        map1.put("distBuildingUnitId", resourceValueDo.getDistBuildingUnitId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("distNeighborhoodResourceId", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        esMgmtStatDistnrDayDo = esMgmtStatDistnrDao.getesMgmtStatDistnrDaySum(stringMap);
                        if (esMgmtStatDistnrDayDo != null) {
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistBuildingUnitId());
                            distnrDayDoList.add(esMgmtStatDistnrDayDo);
                        }
                        break;
                    case 4:
                        map1.put("type", "4");
                        map1.put("distBuildingFloorId", resourceValueDo.getDistBuildingFloorId().toString());
                        list = distnrEloadDao.getDistNeighborhoodByResourceId(map1);
                        idList = ValueUtil.getIdList(list, type);
                        stringMap.put("distNeighborhoodResourceId", idList);
                        stringMap.put("dateStat", map.get("dateStat"));
                        esMgmtStatDistnrDayDo = esMgmtStatDistnrDao.getesMgmtStatDistnrDaySum(stringMap);
                        if (esMgmtStatDistnrDayDo != null) {
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceType(resourceValueDo.getDistNeighborhoodResourceType());
                            esMgmtStatDistnrDayDo.setDistNeighborhoodResourceId(resourceValueDo.getDistBuildingFloorId());
                            distnrDayDoList.add(esMgmtStatDistnrDayDo);
                        }
                    default:
                        break;

                }
            }
        }

        // 日数据统计
        if (distnrDayDoList != null && distnrDayDoList.size() > 0) {
            insertOrUpdateEsMgmtStatDistnrDay(distnrDayDoList);
        }

        // 月数据统计
        List<EsMgmtStatDistnrMonthDo> distnrMonthDoList = esMgmtStatDistnrDao.selectEsMgmtStatDistnrMonthValue(map);
        if (distnrMonthDoList != null && distnrMonthDoList.size() > 0) {
            insertOrUpdateEsMgmtStatDistnrMonth(distnrMonthDoList);
        }

        // 年数据统计
        List<EsMgmtStatDistnrYearDo> distnrYearDoList = esMgmtStatDistnrDao.selectEsMgmtStatDistnrYearValue(map);
        if (distnrYearDoList != null && distnrYearDoList.size() > 0) {
            insertOrUpdateEsMgmtStatDistnrYear(distnrYearDoList);
        }
    }

    private void insertOrUpdateEsMgmtStatDistnrDay(List<EsMgmtStatDistnrDayDo> distnrDayDoList) {
        try {
            distnrDayDoList.forEach(d -> {
                d.setId(idGenerator.nextId());
                d.setGmtCreate(System.currentTimeMillis());
                d.setGmtModified(System.currentTimeMillis());
                d.setVersion(1);
            });

            esMgmtStatDistnrDao.insertOrUpdateEsMgmtStatDistnrDay(distnrDayDoList);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateEsMgmtStatDistnrDay error: " + e.getMessage());
        }
    }

    private void insertOrUpdateEsMgmtStatDistnrMonth(List<EsMgmtStatDistnrMonthDo> distnrMonthDoList) {
        try {
            distnrMonthDoList.forEach(d -> {
                d.setId(idGenerator.nextId());
                d.setGmtCreate(System.currentTimeMillis());
                d.setGmtModified(System.currentTimeMillis());
                d.setVersion(1);
            });

            esMgmtStatDistnrDao.insertOrUpdateEsMgmtStatDistnrMonth(distnrMonthDoList);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateEsMgmtStatDistnrMonth error: " + e.getMessage());
        }
    }

    private void insertOrUpdateEsMgmtStatDistnrYear(List<EsMgmtStatDistnrYearDo> distnrYearDoList) {
        try {
            distnrYearDoList.forEach(d -> {
                d.setId(idGenerator.nextId());
                d.setGmtCreate(System.currentTimeMillis());
                d.setGmtModified(System.currentTimeMillis());
                d.setVersion(1);
            });

            esMgmtStatDistnrDao.insertOrUpdateEsMgmtStatDistnrYear(distnrYearDoList);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateEsMgmtStatDistnrYear error: " + e.getMessage());
        }
    }
}
