package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatOrgDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatOrgDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatOrgMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatOrgYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatOrgDayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
public class EsMgmtStatOrgDayServiceImpl extends AbstractIesmsBaseService implements EsMgmtStatOrgDayService {

    @Autowired
    private EsMgmtStatOrgDayDao esMgmtStatOrgDayDao;

    @Override
    public void statEsMgmtStatOrgValue(Map<String, String> map) {

        List<EsMgmtStatOrgDayDo> cepartEloadDayDoList = esMgmtStatOrgDayDao.getEsMgmtStatOrgDayValue(map);
        insertOrUpdateEsMgmtStatOrgDay(cepartEloadDayDoList);

        List<EsMgmtStatOrgMonthDo> monthDoList = esMgmtStatOrgDayDao.getEsMgmtStatOrgMonthValue(map);

        insertOrUpdateEsMgmtStatOrgMonth(monthDoList);

        List<EsMgmtStatOrgYearDo> yearDoList = esMgmtStatOrgDayDao.getEsMgmtStatOrgYearValue(map);

        insertOrUpdateEsMgmtStatOrgYear(yearDoList);
    }

    private void insertOrUpdateEsMgmtStatOrgDay(List<EsMgmtStatOrgDayDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(CcpartEloadDayDo -> {
                CcpartEloadDayDo.setId(idGenerator.nextId());
                CcpartEloadDayDo.setGmtCreate(System.currentTimeMillis());
                CcpartEloadDayDo.setGmtModified(System.currentTimeMillis());
                CcpartEloadDayDo.setVersion(1);
            });
            try {
                esMgmtStatOrgDayDao.insertOrUpdateCeEsMgmtStatOrgDay(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatOrgDay error:{}", e.getMessage());
            }
        }
    }

    private void insertOrUpdateEsMgmtStatOrgMonth(List<EsMgmtStatOrgMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cepartEloadMonthDo -> {
                cepartEloadMonthDo.setId(idGenerator.nextId());
                cepartEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                cepartEloadMonthDo.setGmtModified(System.currentTimeMillis());
                cepartEloadMonthDo.setVersion(1);
            });

            try {
                esMgmtStatOrgDayDao.insertOrUpdateCeEsMgmtStatOrgMonth(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatOrgMonth error:{}", e.getMessage());
            }
        }
    }

    private void insertOrUpdateEsMgmtStatOrgYear(List<EsMgmtStatOrgYearDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cepartEloadYearDo -> {
                cepartEloadYearDo.setId(idGenerator.nextId());
                cepartEloadYearDo.setGmtCreate(System.currentTimeMillis());
                cepartEloadYearDo.setGmtModified(System.currentTimeMillis());
                cepartEloadYearDo.setVersion(1);
            });

            try {
                esMgmtStatOrgDayDao.insertOrUpdateCeEsMgmtStatOrgYear(list);
            } catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatOrgYear error:{}", e.getMessage());
            }
        }
    }
}
