package com.iesms.openservices.esmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.BenchmarkDataDao;
import com.iesms.openservices.esmgmt.dao.LivingDao;
import com.iesms.openservices.esmgmt.response.*;
import com.iesms.openservices.esmgmt.service.BenchmarkDataService;
import com.iesms.openservices.esmgmt.service.LivingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class LivingServiceImpl extends AbstractIesmsBaseService implements LivingService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private LivingDao livingDao;

    @Override
    public List<SnsUserSetting> findLiving(SnsUserSetting snsUserSetting, Pager pager) {
        return livingDao.findLiving( snsUserSetting,pager);
    }

    @Override
    public Integer findLivingNum(SnsUserSetting snsUserSetting) {
        return livingDao.findLivingNum( snsUserSetting) ;
    }

    @Override
    public List<SnsUserSetting> getSnsUserByUser(SnsUserSetting snsUserSetting) {
        return livingDao.getSnsUserByUser( snsUserSetting) ;
    }

    @Override
    public Integer deleteConfig(String[] soelist1) {
        return livingDao.deleteConfig(soelist1);
    }

    @Override
    public Integer saveConfig(SnsUserConfigLiving snsUserConfigLiving) {
        snsUserConfigLiving.setId(idGenerator.nextId());
        snsUserConfigLiving.setSortSn(1);
        snsUserConfigLiving.setGmtCreate(System.currentTimeMillis());
        snsUserConfigLiving.setGmtModified(System.currentTimeMillis());
        snsUserConfigLiving.setGmtInvalid(0);
        snsUserConfigLiving.setVersion(1);
        return livingDao.saveConfig( snsUserConfigLiving);
    }

    @Override
    public List<SnsUser> getUserAll(SnsUser snsUser) {
        return livingDao.getUserAll( snsUser);
    }
}
