/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.ceresource.entity.CeDeviceDo;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCedeviceDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCedeviceDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCedeviceMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCedeviceYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCedeviceDayService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ibatis.javassist.bytecode.CodeAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EsMgmtStatCedeviceDayServiceImpl
extends AbstractIesmsBaseService
implements EsMgmtStatCedeviceDayService {
    private static final Logger log = LoggerFactory.getLogger(EsMgmtStatCedeviceDayServiceImpl.class);
    @Autowired
    private EsMgmtStatCedeviceDayDao cedeviceDayDao;

    public void ceEsMgmtStatCedevice(Map<String, String> map) {
        List<CeDeviceDo> deviceIdList = this.cedeviceDayDao.getCeDeviceIdsAndCustIds();
        if (deviceIdList == null || deviceIdList.size() < 1) {
            return;
        }
        deviceIdList.removeIf(Objects::isNull);
        Map<Long, List<CeDeviceDo>> listMap = deviceIdList.stream().collect(Collectors.groupingBy(CeDeviceDo::getCeCustId));
        for (List<CeDeviceDo> list : listMap.values()) {
            if (list == null) continue;
            list.removeIf(Objects::isNull);
            if (list.size() < 1) continue;
            ArrayList<EsMgmtStatCedeviceDayDo> inserDaytList = new ArrayList<EsMgmtStatCedeviceDayDo>();
            for (CeDeviceDo ceDeviceDo : list) {
                String deviceId = String.valueOf(ceDeviceDo.getId());
                map.put("deviceId", deviceId);
                EsMgmtStatCedeviceDayDo cedeviceDayDo = this.cedeviceDayDao.getgetEsMgmtStatCedeviceDay(map);
                if (cedeviceDayDo == null) {
                    map.put("deviceParentId", deviceId);
                    List<String> ceDeviceIds = this.cedeviceDayDao.getDeviceIdsByParentId(map);
                    if (ceDeviceIds == null) continue;
                    ceDeviceIds.removeIf(Objects::isNull);
                    if (ceDeviceIds.size() < 1) continue;
                    map.put("ceDeviceIds", deviceId);
                    EsMgmtStatCedeviceDayDo cedeviceSum = this.cedeviceDayDao.getEsMgmtStatCedeviceSum(map);
                    if (cedeviceSum == null) continue;
                    inserDaytList.add(cedeviceSum);
                }
                inserDaytList.add(cedeviceDayDo);
            }
            this.insertOrUpdateCeStatCedeviceEsMgmtDay(inserDaytList);
        }
        this.insertOrUpdateMonthAndYear(map);
    }

    private void insertOrUpdateMonthAndYear(Map<String, String> map) {
        List<EsMgmtStatCedeviceMonthDo> cedeviceMonthDoList = this.cedeviceDayDao.getEsMgmtStatCedeviceMonth(map);
        this.insertOrUpdateCeStatCedeviceEsMgmtMonth(cedeviceMonthDoList);
        List<EsMgmtStatCedeviceYearDo> yearDoList = this.cedeviceDayDao.getEsMgmtStatCedeviceYear(map);
        this.insertOrUpdateCeStatCedeviceEsMgmtYear(yearDoList);
    }

    private void insertOrUpdateCeStatCedeviceEsMgmtDay(List<EsMgmtStatCedeviceDayDo> list) {
        if (list != null && list.size() > 0) {
            list.forEach(cedeviceDayDao -> {
                cedeviceDayDao.setId(Long.valueOf(this.idGenerator.nextId()));
                cedeviceDayDao.setGmtCreate(System.currentTimeMillis());
                cedeviceDayDao.setGmtModified(System.currentTimeMillis());
                cedeviceDayDao.setVersion(1);
            });
            try {
                this.cedeviceDayDao.insertOrUpdateEsMgmtStatCedeviceDay(list);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateCeStatCedeviceEsMgmtDay error:{}", (Object)e.getMessage());
            }
        }
    }

    private void insertOrUpdateCeStatCedeviceEsMgmtMonth(List<EsMgmtStatCedeviceMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.forEach(cedeviceEsMgmtMonthDo -> {
                cedeviceEsMgmtMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                cedeviceEsMgmtMonthDo.setGmtCreate(System.currentTimeMillis());
                cedeviceEsMgmtMonthDo.setGmtModified(System.currentTimeMillis());
                cedeviceEsMgmtMonthDo.setVersion(1);
            });
            try {
                this.cedeviceDayDao.insertOrUpdateEsMgmtStatCedeviceMonth(list);
            }
            catch (CodeAttribute.RuntimeCopyException e) {
                log.error("insertOrUpdateCeStatCedeviceEsMgmtMonth error:{}", (Object)e.getMessage());
            }
        }
    }

    private void insertOrUpdateCeStatCedeviceEsMgmtYear(List<EsMgmtStatCedeviceYearDo> list) {
        if (list != null && list.size() > 0) {
            list.forEach(cedeviceEsMgmtYearDo -> {
                cedeviceEsMgmtYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                cedeviceEsMgmtYearDo.setGmtCreate(System.currentTimeMillis());
                cedeviceEsMgmtYearDo.setGmtModified(System.currentTimeMillis());
                cedeviceEsMgmtYearDo.setVersion(1);
            });
            try {
                this.cedeviceDayDao.insertOrUpdateEsMgmtStatCedeviceYear(list);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateCeStatCedeviceEsMgmtYear error:{}", (Object)e.getMessage());
            }
        }
    }
}

