/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.esmgmt.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.esmgmt.dao.EsMgmtStatCepartDayDao;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCepartDayDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCepartMonthDo;
import com.iesms.openservices.esmgmt.entity.EsMgmtStatCepartYearDo;
import com.iesms.openservices.esmgmt.service.EsMgmtStatCepartDayService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsMgmtStatCepartDayServiceImpl
extends AbstractIesmsBaseService
implements EsMgmtStatCepartDayService {
    private static final Logger log = LoggerFactory.getLogger(EsMgmtStatCepartDayServiceImpl.class);
    @Resource
    private EsMgmtStatCepartDayDao cepartDayDao;

    public void statEsMgmtStatCepartValue(Map<String, String> map) {
        List<EsMgmtStatCepartDayDo> cepartEloadDayDoList = this.cepartDayDao.getEsMgmtStatCepartValueByDevice(map);
        this.insertOrUpdateEsMgmtStatCepartDay(cepartEloadDayDoList);
        List<EsMgmtStatCepartMonthDo> monthDoList = this.cepartDayDao.getEsMgmtCepartMonthValue(map);
        this.insertOrUpdateEsMgmtStatCepartMonth(monthDoList);
        List<EsMgmtStatCepartYearDo> yearDoList = this.cepartDayDao.getEsMgmtCepartYearValue(map);
        this.insertOrUpdateEsMgmtStatCepartYear(yearDoList);
    }

    private void insertOrUpdateEsMgmtStatCepartDay(List<EsMgmtStatCepartDayDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(CcpartEloadDayDo -> {
                CcpartEloadDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                CcpartEloadDayDo.setGmtCreate(System.currentTimeMillis());
                CcpartEloadDayDo.setGmtModified(System.currentTimeMillis());
                CcpartEloadDayDo.setVersion(1);
            });
            try {
                this.cepartDayDao.insertOrUpdateCeEsMgmtStatCepartDay(list);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatCepartDay error:{}", (Object)e.getMessage());
            }
        }
    }

    private void insertOrUpdateEsMgmtStatCepartMonth(List<EsMgmtStatCepartMonthDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cepartEloadMonthDo -> {
                cepartEloadMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                cepartEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                cepartEloadMonthDo.setGmtModified(System.currentTimeMillis());
                cepartEloadMonthDo.setVersion(1);
            });
            try {
                this.cepartDayDao.insertOrUpdateCeEsMgmtStatCepartMonth(list);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatCepartMonth error:{}", (Object)e.getMessage());
            }
        }
    }

    private void insertOrUpdateEsMgmtStatCepartYear(List<EsMgmtStatCepartYearDo> list) {
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            list.forEach(cepartEloadYearDo -> {
                cepartEloadYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                cepartEloadYearDo.setGmtCreate(System.currentTimeMillis());
                cepartEloadYearDo.setGmtModified(System.currentTimeMillis());
                cepartEloadYearDo.setVersion(1);
            });
            try {
                this.cepartDayDao.insertOrUpdateCeEsMgmtStatCepartYear(list);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateEsMgmtStatCepartYear error:{}", (Object)e.getMessage());
            }
        }
    }
}

