/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.jalasmart.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.jalasmart.dao.JalaNetworkMaintenanceDao;
import com.iesms.openservices.jalasmart.entity.CeCustDo;
import com.iesms.openservices.jalasmart.entity.CeCustVo;
import com.iesms.openservices.jalasmart.entity.CeResourceDo;
import com.iesms.openservices.jalasmart.entity.InstPointCeResGatewayDo;
import com.iesms.openservices.jalasmart.entity.JalaSwitchLineParameterDo;
import com.iesms.openservices.jalasmart.entity.JalaSwitchLineTimingConfigVo;
import com.iesms.openservices.jalasmart.service.JalaNetworkMaintenanceService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JalaNetworkMaintenanceServiceImpl
extends AbstractIesmsBaseService
implements JalaNetworkMaintenanceService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JalaNetworkMaintenanceDao jalaNetworkMaintenanceDao;

    @Autowired
    public JalaNetworkMaintenanceServiceImpl(JalaNetworkMaintenanceDao jalaNetworkMaintenanceDao) {
        this.jalaNetworkMaintenanceDao = jalaNetworkMaintenanceDao;
    }

    public List<CeCustVo> getCeCustVoListByOrgNo(String orgNo) {
        return this.jalaNetworkMaintenanceDao.getCeCustVoListByOrgNo(orgNo);
    }

    public CeCustDo insertCeCust(String orgNo, String ceCustName, String ceCustAddr, String ceCustProps, String contacter, String contactPhone, String operator) {
        Long id = this.idGenerator.nextId();
        CeResourceDo ceResourceDo = new CeResourceDo();
        ceResourceDo.setId(id);
        ceResourceDo.setOrgNo(orgNo);
        ceResourceDo.setCeResClass(1);
        ceResourceDo.setCeResNo(String.valueOf(id));
        ceResourceDo.setCeResStatus("20");
        ceResourceDo.setCeResName(ceCustName);
        ceResourceDo.setCeResAbbr(ceCustName);
        ceResourceDo.setCeResDesc(ceCustName);
        ceResourceDo.setElecCapacity(new BigDecimal(1.0));
        ceResourceDo.setVoltageClass("380");
        ceResourceDo.setSortSn(1);
        ceResourceDo.setValid(true);
        ceResourceDo.setCreator(operator);
        ceResourceDo.setGmtCreate(System.currentTimeMillis());
        ceResourceDo.setModifier(operator);
        ceResourceDo.setGmtModified(System.currentTimeMillis());
        ceResourceDo.setInvalider("");
        ceResourceDo.setGmtInvalid(0L);
        ceResourceDo.setVersion(1);
        int resultInsertCeResource = this.jalaNetworkMaintenanceDao.insertCeResource(ceResourceDo);
        if (resultInsertCeResource > 0) {
            CeCustDo ceCustDo = new CeCustDo();
            ceCustDo.setId(id);
            ceCustDo.setCeCustType(1);
            ceCustDo.setCeCustCredNo("");
            ceCustDo.setCeCustCredAttach("");
            ceCustDo.setContacter(contacter);
            ceCustDo.setContactPhone(contactPhone);
            ceCustDo.setEnableElec(true);
            ceCustDo.setConsElecSort("");
            ceCustDo.setConsElecReadingDay(0);
            ceCustDo.setConsElecLevel(0);
            ceCustDo.setParentElecCustId(Long.valueOf(0L));
            ceCustDo.setEnableWater(false);
            ceCustDo.setConsWaterSort("");
            ceCustDo.setConsWaterReadingDay(0);
            ceCustDo.setConsWaterLevel(0);
            ceCustDo.setParentWaterCustId(Long.valueOf(0L));
            ceCustDo.setEnableGas(false);
            ceCustDo.setConsGasSort("");
            ceCustDo.setConsGasReadingDay(0);
            ceCustDo.setConsGasLevel(0);
            ceCustDo.setParentGasCustId(Long.valueOf(0L));
            ceCustDo.setEnableHeat(false);
            ceCustDo.setConsHeatSort("");
            ceCustDo.setConsHeatReadingDay(0);
            ceCustDo.setConsHeatLevel(0);
            ceCustDo.setParentHeatCustId(Long.valueOf(0L));
            ceCustDo.setEnableSteam(false);
            ceCustDo.setConsSteamSort("");
            ceCustDo.setConsSteamReadingDay(0);
            ceCustDo.setConsSteamLevel(0);
            ceCustDo.setParentSteamCustId(Long.valueOf(0L));
            ceCustDo.setCeCustAddr(ceCustAddr);
            ceCustDo.setCeCustIntro(ceCustName);
            ceCustDo.setCeCustProps(ceCustProps);
            ceCustDo.setTradeCode("");
            ceCustDo.setAdcode("");
            ceCustDo.setCitycode("");
            this.jalaNetworkMaintenanceDao.insertCeCust(ceCustDo);
        }
        return this.jalaNetworkMaintenanceDao.getCeCust(id);
    }

    public int insertInstPointCeResGateway(InstPointCeResGatewayDo instPointCeResGatewayDo) {
        instPointCeResGatewayDo.setId(Long.valueOf(this.idGenerator.nextId()));
        return this.jalaNetworkMaintenanceDao.insertInstPointCeResGateway(instPointCeResGatewayDo);
    }

    public List<InstPointCeResGatewayDo> getInstPointCeResGatewayDoListByCeResId(Long ceResId) {
        return this.jalaNetworkMaintenanceDao.getInstPointCeResGatewayDoListByCeResId(ceResId);
    }

    public int updateCeCust(String snValue, Long id, String ceCustName, String ceCustAddr, String ceCustProps, String contacter, String contactPhone, String operator) {
        CeResourceDo ceResourceDo = this.jalaNetworkMaintenanceDao.getCeResource(id);
        ceResourceDo.setOrgNo(operator);
        ceResourceDo.setCeResName(ceCustName);
        ceResourceDo.setCeResAbbr(ceCustAddr);
        ceResourceDo.setCeResDesc(ceCustName);
        ceResourceDo.setModifier(operator);
        ceResourceDo.setGmtModified(System.currentTimeMillis());
        ceResourceDo.setCeCustType(1);
        ceResourceDo.setCeCustCredNo("111111");
        ceResourceDo.setCeCustCredAttach(String.valueOf(this.idGenerator.nextId()));
        ceResourceDo.setContacter(contacter);
        ceResourceDo.setContactPhone(contactPhone);
        ceResourceDo.setEnableElec(true);
        ceResourceDo.setConsElecSort("1");
        ceResourceDo.setSortSn(1);
        ceResourceDo.setValid(true);
        int result = this.jalaNetworkMaintenanceDao.updateCeResource(ceResourceDo);
        if (result > 0) {
            CeCustDo ceCustDo = this.jalaNetworkMaintenanceDao.getCeCust(id);
            ceCustDo.setContacter(contacter);
            ceCustDo.setContactPhone(contactPhone);
            ceCustDo.setCeCustAddr(ceCustAddr);
            ceCustDo.setCeCustIntro(ceCustName);
            ceCustDo.setCeCustProps(ceCustProps);
            return this.jalaNetworkMaintenanceDao.updateCeCust(ceCustDo);
        }
        return result;
    }

    public int deleteNetwork(Long id) {
        CeResourceDo ceResourceDo;
        CeCustDo ceCustDo = this.jalaNetworkMaintenanceDao.getCeCust(id);
        int result = this.jalaNetworkMaintenanceDao.deleteCeCust(ceCustDo);
        if (result > 0 && (result = this.jalaNetworkMaintenanceDao.deleteCeResource(ceResourceDo = this.jalaNetworkMaintenanceDao.getCeResource(id))) > 0) {
            result = this.jalaNetworkMaintenanceDao.deleteInstPointCeResGatewayByCeResId(id);
        }
        return result;
    }

    public List<JalaSwitchLineTimingConfigVo> getLineTimingConfig() {
        return this.jalaNetworkMaintenanceDao.getLineTimingConfig();
    }

    public List<InstPointCeResGatewayDo> getInstPoint(Long sn) {
        return this.jalaNetworkMaintenanceDao.getInstPoint(sn);
    }

    public List<JalaSwitchLineTimingConfigVo> getConfigSN(Long key) {
        return this.jalaNetworkMaintenanceDao.getConfigSN(key);
    }

    public List<CeCustDo> getCeGetCust(Long id) {
        return this.jalaNetworkMaintenanceDao.getCeGetCust(id);
    }

    public List<JalaSwitchLineParameterDo> queryThreshold(Long accessGatewayid, Long measPointId) {
        return this.jalaNetworkMaintenanceDao.queryThreshold(accessGatewayid, measPointId);
    }

    public int insertThreshold(JalaSwitchLineParameterDo jsd) {
        jsd.setId(Long.valueOf(this.idGenerator.nextId()));
        return this.jalaNetworkMaintenanceDao.insertThreshold(jsd);
    }

    public int updateThreshold(String jsonValue, Long id) {
        return this.jalaNetworkMaintenanceDao.updateThreshold(jsonValue, id);
    }

    public int deleteInstPointDo(String id) {
        return this.jalaNetworkMaintenanceDao.deleteInstPointDo(id);
    }

    public int queryCustNum(String orgNo, String ceCustName) {
        return this.jalaNetworkMaintenanceDao.queryCustNum(orgNo, ceCustName);
    }
}

