package com.iesms.openservices.jzhp.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class AccountExceptionHandlingReportVo implements Serializable {
    /**
     *户号
     */
    private String userNo;
    /**
     *小区/企业
     */
    private String neighborhoodName;
    /**
     *用户
     */
    private String ceResName;
    /**
     *用户地址
     */
    private String address;
    /**
     * 交易请求标识;SnowflakeId
     */
    private Long id ;
    /**
     *  交易请求时间
     */
    private String orderRequestTime ;
    /**
     * 交易金额
     */
    private BigDecimal orderMoney ;
    /**
     * 系统单位编号
     */
    private String orgNo ;
    /**
     * 用能客户标识
     */
    private Long ceCustId ;
    /**
     * 处理类型;1 - 退还用户；2 - 用户补缴；
     */
    private String handleType ;
    /**
     * 处理说明
     */
    private String handleDesc ;
    /**
     * 支付时间
     */
    private String payTime ;
    /**
     * 支付结果;0 - 初始；1 - 支付成功；2 - 支付失败；
     */
    private int payResult ;
    /**
     * 支付订单标识
     */
    private String payOrderId ;
    /**
     *  是否有效
     */
    private boolean isValid ;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator ;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate ;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier ;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified ;
    /**
     * 版本号;用于乐观锁
     */
    private int version ;
    /**
     *退补人
     */
    private String userFullName;
    /**
     * 序号
     */
    private String key;
}
