package com.iesms.openservices.jzhp.entity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CeCustVo implements  Serializable{

    @JsonSerialize(using = ToStringSerializer.class)

    /** 用能资源标识;SnowflakeId */
    private Long id ;
    /** 用能客户类型;1 - 企业；2 - 个人；11 - 公用配电台区；12 - 分布式光伏电站；41 - 热力站； */
    private int ceCustType ;
    /** 用能客户证件号码 */
    private String ceCustCredNo ;
    /** 用能客户证件附件 */
    private String ceCustCredAttach ;
    /** 联系人 */
    private String contacter ;
    /** 联系电话 */
    private String contactPhone ;
    /** 是否用电 */
    private boolean isEnableElec ;
    /** 用电分类;编码 CE_CONS_ELEC_SORT：
     A – 大型专变用户；
     B – 中小型专变用户；
     C – 三相一般工商业用户；
     D – 单相一般工商业用户；
     E – 居民用户；
     F – 公用配变； */
    private String consElecSort ;
    /** 用电抄表例日 */
    private int consElecReadingDay ;
    /** 用电层级 */
    private int consElecLevel ;
    /** 上级用能客户（用电）;无上级用能客户标识填0 */
    private Long parentElecCustId ;
    /** 是否用水 */
    private boolean isEnableWater ;
    /** 用水分类;编码 CE_CONS_WATER_SORT */
    private String consWaterSort ;
    /** 用水抄表例日 */
    private int consWaterReadingDay ;
    /** 用水层级 */
    private int consWaterLevel ;
    /** 上级用能客户（用水）;无上级用能客户标识填0 */
    private Long parentWaterCustId ;
    /** 是否用气 */
    private boolean isEnableGas ;
    /** 用气分类;编码 CE_CONS_GAS_SORT */
    private String consGasSort ;
    /** 用气抄表例日 */
    private int consGasReadingDay ;
    /** 用气层级 */
    private int consGasLevel ;
    /** 上级用能客户（用气） */
    private Long parentGasCustId ;
    /** 是否用热 */
    private boolean isEnableHeat ;
    /** 用热分类;编码 CE_CONS_HEAT_SORT */
    private String consHeatSort ;
    /** 用热抄表例日 */
    private int consHeatReadingDay ;
    /** 用热层级 */
    private int consHeatLevel ;
    /** 上级用能客户（用热）;无上级用能客户标识填0 */
    private Long parentHeatCustId ;
    /** 是否用汽 */
    private boolean isEnableSteam ;
    /** 用汽分类;编码 CE_CONS_STEAM_SORT */
    private String consSteamSort ;
    /** 用汽抄表例日 */
    private int consSteamReadingDay ;
    /** 用汽层级 */
    private int consSteamLevel ;
    /** 上级用能客户（用汽）;无上级用能客户标识填0 */
    private Long parentSteamCustId ;
    /** 用能客户地址 */
    private String ceCustAddr ;
    /** 用能客户介绍 */
    private String ceCustIntro ;
    /** 用能客户属性集 */
    private String ceCustProps ;
    /** 行业分类 */
    private String tradeCode ;
    /** 区域编码 */
    private String adcode ;
    /** 城市编码 */
    private String citycode ;
    /** 经度 */
    private BigDecimal longitude ;
    /** 纬度 */
    private BigDecimal latitude ;

}