package com.iesms.openservices.jzhp.entity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class CeResourceVo implements  Serializable{

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id ;
    /** 系统单位编号 */
    private String orgNo ;
    /** 用能资源类别;1 - 用能客户；
     2 - 用能区域；
     3 - 用能容器；
     4 - 用能设备； */
    private int ceResClass ;
    /** 用能资源编号 */
    private String ceResNo ;
    /** 用能资源状态;编码CE_RES_STATUS：
     10 – 未投运；
     20 – 投运；
     30 – 暂停；
     40 – 退运； */
    private String ceResStatus ;
    /** 用能资源名称 */
    private String ceResName ;
    /** 用能资源简称 */
    private String ceResAbbr ;
    /** 用能资源说明 */
    private String ceResDesc ;
    /** 用电容量 */
    private BigDecimal elecCapacity ;
    /** 电压等级;编码CE_VOLTAGE_CLASS */
    private String voltageClass ;
    /** 排序序号 */
    private int sortSn ;
    /** 是否有效 */
    private boolean isValid ;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator ;
    /** 创建时间;为0表示为空 */
    private long gmtCreate ;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier ;
    /** 更新时间;为0表示为空 */
    private long gmtModified ;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider ;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid ;
    /** 版本号;用于乐观锁 */
    private int version ;
}