package com.iesms.openservices.jzhp.entity;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
@Data
public class NeighborhoodVo implements Serializable{
    /**
     * 小区标识;SnowflakeId
     */
    private String id;
    /**
     * 系统单位编号
     */
    private String orgNo;
    /**
     * 自定义行政区标识
     */
    private long customDistId;
    /**
     * 小区名称
     */
    private String neighborhoodName;
    /**
     * 小区类型;1 - 居民小区；2 - 企业园区；
     */
    private int neighborhoodType;
    /**
     * 小区简称
     */
    private String neighborhoodAbbr;
    /**
     * 小区地址
     */
    private String neighborhoodAddr;
    /**
     * 占地面积;单位：平方米
     */
    private BigDecimal coverageArea;
    /**
     * 建筑面积;单位：平方米
     */
    private BigDecimal buildingArea;
    /**
     * 楼幢数
     */
    private int buildingCount;
    /**
     * 户数
     */
    private int householdCount;
    /**
     * 联系人
     */
    private String contacter;
    /**
     * 联系电话
     */
    private String contactPhone;
    /**
     * 区域编码
     */
    private String adcode;
    /**
     * 城市编码
     */
    private String citycode;
    /**
     * 经度
     */
    private BigDecimal longitude;
    /**
     * 纬度
     */
    private BigDecimal latitude;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean isValid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;

}