package com.iesms.openservices.jzhp.entity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class SoeRecordVo implements  Serializable{
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id ;
    /** 系统单位编号 */
    private String orgNo ;
    /** 事件对象类型;1 - 采集终端设备；2 - 采集器设备；3 - 量测表计设备；10 - 用能点；20 - 用能资源； */
    private int soeObjectType ;
    /** 事件对象标识 */
    private Long soeObjectId ;
    /** 事件对象名称 */
    private String soeObjectName ;
    /** 事件分类编号 */
    private String soeSortNo ;
    /** 事件等级;1 - 一般事件；2 - 次要事件；3 - 重要事件； */
    private int soeLevel ;
    /** 严重等级;1 - 轻微；2 - 普通；3 - 严重； */
    private int graveLevel ;
    /** 事件标题 */
    private String soeTitle ;
    /** 事件说明 */
    private String soeDesc ;
    /** 事件发生时间 */
    private Date soeGenTime ;
    /** 事件发生值 */
    private String soeGenValue ;
    /** 是否复归 */
    private boolean isRecovery ;
    /** 事件复归时间 */
    private Date soeRecTime ;
    /** 事件复归值 */
    private String soeRecValue ;
    /** 排序序号 */
    private int sortSn ;
    /** 是否有效 */
    private boolean isValid ;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator ;
    /** 创建时间;为0表示为空 */
    private long gmtCreate ;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier ;
    /** 更新时间;为0表示为空 */
    private long gmtModified ;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider ;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid ;
    /** 版本号;用于乐观锁 */
    private int version ;



    /** 事件分类名称 */
    private String soeSortName ;
    /** 事件分类别名 */
    private String soeSortAlias ;
    /** 事件分类说明 */
    private String soeSortDesc ;



    /** 用能客户类型;1 - 企业；2 - 个人；11 - 公用配电台区；12 - 分布式光伏电站；41 - 热力站； */
    private int ceCustType ;
    /** 用能客户证件号码 */
    private String ceCustCredNo ;
    /** 用能客户证件附件 */
    private String ceCustCredAttach ;
    /** 联系人 */
    private String contacter ;
    /** 联系电话 */
    private String contactPhone ;
    /** 是否用电 */
    private boolean isEnableElec ;
    /** 用电分类;编码 CE_CONS_ELEC_SORT：
     A – 大型专变用户；
     B – 中小型专变用户；
     C – 三相一般工商业用户；
     D – 单相一般工商业用户；
     E – 居民用户；
     F – 公用配变； */
    private String consElecSort ;
    /** 用电抄表例日 */
    private int consElecReadingDay ;
    /** 用电层级 */
    private int consElecLevel ;
    /** 上级用能客户（用电）;无上级用能客户标识填0 */
    private Long parentElecCustId ;
    /** 是否用水 */
    private boolean isEnableWater ;
    /** 用水分类;编码 CE_CONS_WATER_SORT */
    private String consWaterSort ;
    /** 用水抄表例日 */
    private int consWaterReadingDay ;
    /** 用水层级 */
    private int consWaterLevel ;
    /** 上级用能客户（用水）;无上级用能客户标识填0 */
    private Long parentWaterCustId ;
    /** 是否用气 */
    private boolean isEnableGas ;
    /** 用气分类;编码 CE_CONS_GAS_SORT */
    private String consGasSort ;
    /** 用气抄表例日 */
    private int consGasReadingDay ;
    /** 用气层级 */
    private int consGasLevel ;
    /** 上级用能客户（用气） */
    private Long parentGasCustId ;
    /** 是否用热 */
    private boolean isEnableHeat ;
    /** 用热分类;编码 CE_CONS_HEAT_SORT */
    private String consHeatSort ;
    /** 用热抄表例日 */
    private int consHeatReadingDay ;
    /** 用热层级 */
    private int consHeatLevel ;
    /** 上级用能客户（用热）;无上级用能客户标识填0 */
    private Long parentHeatCustId ;
    /** 是否用汽 */
    private boolean isEnableSteam ;
    /** 用汽分类;编码 CE_CONS_STEAM_SORT */
    private String consSteamSort ;
    /** 用汽抄表例日 */
    private int consSteamReadingDay ;
    /** 用汽层级 */
    private int consSteamLevel ;
    /** 上级用能客户（用汽）;无上级用能客户标识填0 */
    private Long parentSteamCustId ;
    /** 用能客户地址 */
    private String ceCustAddr ;
    /** 用能客户介绍 */
    private String ceCustIntro ;
    /** 用能客户属性集 */
    private String ceCustProps ;
    /** 行业分类 */
    private String tradeCode ;
    /** 区域编码 */
    private String adcode ;
    /** 城市编码 */
    private String citycode ;
    /** 经度 */
    private BigDecimal longitude ;
    /** 纬度 */
    private BigDecimal latitude ;

    private String   devTermNo;
    private String  devTermName;
    private Integer devTermStatus;







}