package com.iesms.openservices.photovoltaic.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode
@ToString
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class IesmsNormalEntity implements Serializable {

    private static final long serialVersionUID = 1615886613043311441L;

    /**
     * 主键标识
     * SnowflakeId
     */
    @TableId(type = IdType.ASSIGN_ID)
    protected Long id;

    /**
     * 排序序号
     */
    @TableField(fill = FieldFill.INSERT)
    protected Integer sortSn;

    /**
     * 是否有效
     */
    @TableField(fill = FieldFill.INSERT)
    private Boolean isValid;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    @TableField(fill = FieldFill.INSERT)
    protected String creator;

    /**
     * 创建时间;为0表示为空
     */
    @TableField(fill = FieldFill.INSERT)
    protected Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    protected String modifier;

    /**
     * 更新时间;为0表示为空
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    protected Long gmtModified;

    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    @TableField(fill = FieldFill.INSERT)
    protected String invalider;

    /**
     * 失效时间;为0表示为空
     */
    @TableField(fill = FieldFill.INSERT)
    protected Long gmtInvalid;

    /**
     * 版本号;用于乐观锁
     */
    @TableField(fill = FieldFill.INSERT)
    @Version
    protected Integer version;
}
