package com.iesms.openservices.photovoltaic.entity;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class AgEffectEventDto implements Serializable {

    /**
     * 策略内容
     */
    private String eventContent;

    /**
     * 0-未执行；1-已执行
     */
    private String isRecovery;

    /**
     * 预计减少电能消耗
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal expectedReductionEconsValue;

    /**
     * 实际减少电能消耗
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal actuallyReductionEconsValue;
}
