package com.iesms.openservices.photovoltaic.entity;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 大莲花首页--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2022-04-07
 */
@Data
public class AgHomePageDto implements Serializable {

    /**
     * 室内温湿度照度终端数
     */
    private int indoorTermCount;

    /**
     * 室外终端数
     */
    private int outdoorTermCount;

    /**
     * 降碳提效路由器数
     */
    private int routerCount;

    /**
     * 人体探测终端数
     */
    private int bodyProbeTermCount;

    /**
     * 在线感知终端数
     */
    private int onlinePerTermCount;

    /**
     * 在线能源路由器数
     */
    private int onlineRouterCount;

    /**
     * 光伏装机容量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal pvInstalledCapacity;

    /**
     * 储能装机容量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal seInstalledCapacity;

    /**
     * 已执行策略数
     */
    private int executedStrategyCount;

    /**
     * 安全运行小时数
     */
    private String safeOperatingHours;

    /**
     * 减少电能消耗
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal reductionEconsValue;

    /**
     * 减少二氧化碳
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal reduceCO2Value;

    /**
     * 当前室内温度
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curTempIndoor;

    /**
     * 当前室内湿度
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curHumIndoor;

    /**
     * 当前室内光照强度（照度）
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curLumIndoor;

    /**
     * 当前人流量
     */
    private int curHumanTraffic;

    /**
     * 当前响应负荷
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curResLoad;

    /**
     * 当前照明负荷
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curLightLoad;

    /**
     * 当前空调负荷
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curAcLoad;

    /**
     * 楼层下的房间id
     */
    private String ceCntrIds;

    /**
     * 楼层或房间id
     */
    private String ceResId;

    /**
     * 楼层或房间编号
     */
    private String ceResNo;

    /**
     * 楼层或房间名称
     */
    private String ceResName;

}
