package com.iesms.openservices.photovoltaic.entity;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 降碳提效日统计（按用能容器）
 */
@Data
public class AgStatCecntrCreDayDto implements Serializable {

    /**
     * 用能统计标识;SnowflakeId
     */
    private Long id;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 用能容器标识
     */
    private Long ceCntrId;

    /**
     * 用能资源（容器）分类编号;见用能资源分类表
     */
    private String ceResSortNo;

    /**
     * 统计日期
     */
    private String dateStat;

    /**
     * 综合实际减少电能消耗量01;00:00 – 01:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsOverallValue01;

    /**
     * 综合实际减少电能消耗量02;01:00 – 02:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsOverallValue02;

    /**
     * 综合实际减少电能消耗量03
     */
    private BigDecimal arEconsOverallValue03;

    /**
     * 综合实际减少电能消耗量04
     */
    private BigDecimal arEconsOverallValue04;

    /**
     * 综合实际减少电能消耗量06
     */
    private BigDecimal arEconsOverallValue06;

    /**
     * 综合实际减少电能消耗量05
     */
    private BigDecimal arEconsOverallValue05;

    /**
     * 综合实际减少电能消耗量07
     */
    private BigDecimal arEconsOverallValue07;

    /**
     * 综合实际减少电能消耗量08
     */
    private BigDecimal arEconsOverallValue08;

    /**
     * 综合实际减少电能消耗量09
     */
    private BigDecimal arEconsOverallValue09;

    /**
     * 综合实际减少电能消耗量10
     */
    private BigDecimal arEconsOverallValue10;

    /**
     * 综合实际减少电能消耗量11
     */
    private BigDecimal arEconsOverallValue11;

    /**
     * 综合实际减少电能消耗量12
     */
    private BigDecimal arEconsOverallValue12;

    /**
     * 综合实际减少电能消耗量13
     */
    private BigDecimal arEconsOverallValue13;

    /**
     * 综合实际减少电能消耗量14
     */
    private BigDecimal arEconsOverallValue14;

    /**
     * 综合实际减少电能消耗量15
     */
    private BigDecimal arEconsOverallValue15;

    /**
     * 综合实际减少电能消耗量16
     */
    private BigDecimal arEconsOverallValue16;

    /**
     * 综合实际减少电能消耗量17
     */
    private BigDecimal arEconsOverallValue17;

    /**
     * 综合实际减少电能消耗量18
     */
    private BigDecimal arEconsOverallValue18;

    /**
     * 综合实际减少电能消耗量19
     */
    private BigDecimal arEconsOverallValue19;

    /**
     * 综合实际减少电能消耗量20
     */
    private BigDecimal arEconsOverallValue20;

    /**
     * 综合实际减少电能消耗量21
     */
    private BigDecimal arEconsOverallValue21;

    /**
     * 综合实际减少电能消耗量22
     */
    private BigDecimal arEconsOverallValue22;

    /**
     * 综合实际减少电能消耗量23
     */
    private BigDecimal arEconsOverallValue23;

    /**
     * 综合实际减少电能消耗量24;23:00 – 24:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsOverallValue24;

    /**
     * 温湿度实际减少电能消耗量01;00:00 – 01:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsTempValue01;

    /**
     * 温湿度实际减少电能消耗量02;01:00 – 02:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsTempValue02;

    /**
     * 温湿度实际减少电能消耗量03
     */
    private BigDecimal arEconsTempValue03;

    /**
     * 温湿度实际减少电能消耗量04
     */
    private BigDecimal arEconsTempValue04;

    /**
     * 温湿度实际减少电能消耗量06
     */
    private BigDecimal arEconsTempValue06;

    /**
     * 温湿度实际减少电能消耗量05
     */
    private BigDecimal arEconsTempValue05;

    /**
     * 温湿度实际减少电能消耗量07
     */
    private BigDecimal arEconsTempValue07;

    /**
     * 温湿度实际减少电能消耗量08
     */
    private BigDecimal arEconsTempValue08;

    /**
     * 温湿度实际减少电能消耗量09
     */
    private BigDecimal arEconsTempValue09;

    /**
     * 温湿度实际减少电能消耗量10
     */
    private BigDecimal arEconsTempValue10;

    /**
     * 温湿度实际减少电能消耗量11
     */
    private BigDecimal arEconsTempValue11;

    /**
     * 温湿度实际减少电能消耗量12
     */
    private BigDecimal arEconsTempValue12;

    /**
     * 温湿度实际减少电能消耗量13
     */
    private BigDecimal arEconsTempValue13;

    /**
     * 温湿度实际减少电能消耗量14
     */
    private BigDecimal arEconsTempValue14;

    /**
     * 温湿度实际减少电能消耗量15
     */
    private BigDecimal arEconsTempValue15;

    /**
     * 温湿度实际减少电能消耗量16
     */
    private BigDecimal arEconsTempValue16;

    /**
     * 温湿度实际减少电能消耗量18
     */
    private BigDecimal arEconsTempValue18;

    /**
     * 温湿度实际减少电能消耗量17
     */
    private BigDecimal arEconsTempValue17;

    /**
     * 温湿度实际减少电能消耗量19
     */
    private BigDecimal arEconsTempValue19;

    /**
     * 温湿度实际减少电能消耗量20
     */
    private BigDecimal arEconsTempValue20;

    /**
     * 温湿度实际减少电能消耗量21
     */
    private BigDecimal arEconsTempValue21;

    /**
     * 温湿度实际减少电能消耗量22
     */
    private BigDecimal arEconsTempValue22;

    /**
     * 温湿度实际减少电能消耗量23
     */
    private BigDecimal arEconsTempValue23;

    /**
     * 温湿度实际减少电能消耗量24;23:00 – 24:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsTempValue24;

    /**
     * 照度实际减少电能消耗量01;00:00 – 01:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsLuxValue01;

    /**
     * 照度实际减少电能消耗量02;01:00 – 02:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsLuxValue02;

    /**
     * 照度实际减少电能消耗量03
     */
    private BigDecimal arEconsLuxValue03;

    /**
     * 照度实际减少电能消耗量04
     */
    private BigDecimal arEconsLuxValue04;

    /**
     * 照度实际减少电能消耗量06
     */
    private BigDecimal arEconsLuxValue06;

    /**
     * 照度实际减少电能消耗量05
     */
    private BigDecimal arEconsLuxValue05;

    /**
     * 照度实际减少电能消耗量07
     */
    private BigDecimal arEconsLuxValue07;

    /**
     * 照度实际减少电能消耗量08
     */
    private BigDecimal arEconsLuxValue08;

    /**
     * 照度实际减少电能消耗量09
     */
    private BigDecimal arEconsLuxValue09;

    /**
     * 照度实际减少电能消耗量10
     */
    private BigDecimal arEconsLuxValue10;

    /**
     * 照度实际减少电能消耗量11
     */
    private BigDecimal arEconsLuxValue11;

    /**
     * 照度实际减少电能消耗量12
     */
    private BigDecimal arEconsLuxValue12;

    /**
     * 照度实际减少电能消耗量13
     */
    private BigDecimal arEconsLuxValue13;

    /**
     * 照度实际减少电能消耗量14
     */
    private BigDecimal arEconsLuxValue14;

    /**
     * 照度实际减少电能消耗量15
     */
    private BigDecimal arEconsLuxValue15;

    /**
     * 照度实际减少电能消耗量16
     */
    private BigDecimal arEconsLuxValue16;

    /**
     * 照度实际减少电能消耗量18
     */
    private BigDecimal arEconsLuxValue18;

    /**
     * 照度实际减少电能消耗量17
     */
    private BigDecimal arEconsLuxValue17;

    /**
     * 照度实际减少电能消耗量19
     */
    private BigDecimal arEconsLuxValue19;

    /**
     * 照度实际减少电能消耗量20
     */
    private BigDecimal arEconsLuxValue20;

    /**
     * 照度实际减少电能消耗量21
     */
    private BigDecimal arEconsLuxValue21;

    /**
     * 照度实际减少电能消耗量22
     */
    private BigDecimal arEconsLuxValue22;

    /**
     * 照度实际减少电能消耗量23
     */
    private BigDecimal arEconsLuxValue23;

    /**
     * 照度实际减少电能消耗量24;23:00 – 24:00实际减少电能消耗量，单位：kWh
     */
    private BigDecimal arEconsLuxValue24;

    /**
     * 综合日实际减少电能消耗量;单位：kWh
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal arEconsOverallValueDay;

    /**
     * 综合日已执行降碳提效事件数
     */
    private int executedCreEventOverallCountDay;

    /**
     * 综合日总降碳提效事件数
     */
    private int totalCreEventOverallCountDay;

    /**
     * 温湿度日实际减少电能消耗量;单位：kWh
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal arEconsTempValueDay;

    /**
     * 温湿度日已执行降碳提效事件数
     */
    private int executedCreEventTempCountDay;

    /**
     * 温湿度日总降碳提效事件数
     */
    private int totalCreEventTempCountDay;

    /**
     * 照度日实际减少电能消耗量;单位：kWh
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal arEconsLuxValueDay;

    /**
     * 照度日已执行降碳提效事件数
     */
    private int executedCreEventLuxCountDay;

    /**
     * 照度日总降碳提效事件数
     */
    private int totalCreEventLuxCountDay;

    /**
     * 综合累计实际减少电能消耗量;单位：kWh
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal arEconsOverallValueAccum;

    /**
     * 综合累计已执行降碳提效事件数
     */
    private int executedCreEventOverallCountAccum;

    /**
     * 综合累计总降碳提效事件数
     */
    private int totalCreEventOverallCountAccum;

    /**
     * 温湿度累计实际减少电能消耗量;单位：kWh
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal arEconsTempValueAccum;

    /**
     * 温湿度累计已执行降碳提效事件数
     */
    private int executedCreEventTempCountAccum;

    /**
     * 温湿度累计总降碳提效事件数
     */
    private int totalCreEventTempCountAccum;

    /**
     * 照度累计实际减少电能消耗量;单位：kWh
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal arEconsLuxValueAccum;

    /**
     * 照度累计已执行降碳提效事件数
     */
    private int executedCreEventLuxCountAccum;

    /**
     * 照度累计总降碳提效事件数
     */
    private int totalCreEventLuxCountAccum;

    /**
     * 当前综合能效状态;1 - 优；2 - 良；3 - 中；4 - 差；
     */
    private int curEnergyEffOverallState;

    /**
     * 当前温湿度能效状态;1 - 优；2 - 良；3 - 中；4 - 差；
     */
    private int curEnergyEffTempState;

    /**
     * 当前照度能效状态;1 - 优；2 - 良；3 - 中；4 - 差；
     */
    private int curEnergyEffLuxState;

    /**
     * 当前室内温度;单位：℃
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curTempIndoor;

    /**
     * 当前室内湿度;单位：%RH
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curHumIndoor;

    /**
     * 当前出风口温度;单位：℃
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curTempOutlet;

    /**
     * 当前出风口湿度;单位：%RH
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curHumOutlet;

    /**
     * 当前室外光照强度;单位：Lux
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curLumOutdoor;

    /**
     * 当前室内光照强度;单位：Lux
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curLumIndoor;

    /**
     * 当前体感温度;单位：℃
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curTempHumanBody;

    /**
     * 当前人流量
     */
    private int curHumanTraffic;

    /**
     * 当前响应负荷;单位：kW
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curResLoad;

    /**
     * 当前照明负荷;单位：kW
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curLightLoad;

    /**
     * 当前空调负荷;单位：kW
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curAcLoad;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 版本号;用于乐观锁
     */
    private int version;

}
