package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

@Data
@Accessors(chain = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class CeDevice implements Serializable {
    /**
     * 用能资源标识;SnowflakeId
     */
    private Long id;

    /**
     * 用能资源（设备）分类编号;见用能资源分类表
     */
    private String ceResSortNo;

    /**
     * 上级用能资源类别;1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备；
     */
    private Integer parentCeResClass;

    /**
     * 上级用能资源标识
     */
    private Long parentCeResId;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 用能区域标识;如果上级用能资源类别位1 – 用能客户，则该字段为0
     */
    private Long cePartId;

    /**
     * 用能容器标识;如果上级用能资源类别位1 – 用能客户 或 2 – 用能区域，则该字段为0
     */
    private Long ceCntrId;

    /**
     * 上级用能设备标识;如果上级用能资源类别位1 – 用能客户 或 2 – 用能区域 或 3 - 用能容器，则该字段为0
     */
    private Long parentId;

    /**
     * 用能设备属性集
     */
    private String ceDevProps;

}
