package com.iesms.openservices.photovoltaic.entity;

import lombok.*;
import lombok.experimental.Accessors;
import org.checkerframework.checker.units.qual.N;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @param
 * @ClassName CleaningEfficiency  清洁效果评价实体
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/10/25 14:16
 * @Version 1.0
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Builder
public class CleaningEfficiency implements Serializable {

    /***
     * 当日增发电量
     */

    private BigDecimal dailyGenerationIncrease;

    /***
     * 当日增发收入
     */

    private BigDecimal dailyIncomeIncrease;


    /***
     * 累计增发电量
     */

    private BigDecimal generationIncreaseAccum;

    /***
     * 累计增发收入
     */

    private BigDecimal incomeIncreaseAccum;

    /***
     * 参考单元发电效率
     */

    private BigDecimal  unitGenerationEfficiency;


    /***
     * 参考单元平均值
     */

    private BigDecimal unitAvg;


    /***
     * 清洗部分发电效率
     */

    private BigDecimal cleaningEfficiency;


    /***
     * 清洗部分平均值
     */

    private BigDecimal cleaningAvg;


    /***
     * 参考单元发电量
     */

    private BigDecimal unitGeneratingCapacity;

    /***
     * 清洗部分发电量
     */

    private BigDecimal cleaningGeneratingCapacity;

    /***
     * 日期
     */
    private String date;


}
