package com.iesms.openservices.photovoltaic.entity;

import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.iesms.openservices.photovoltaic.jsonobject.DayouWordOrderInspectionDetailsJsonObject;
import com.iesms.openservices.photovoltaic.jsonobject.DayouWordOrderOtherInfoJsonObject;
import com.iesms.openservices.photovoltaic.jsonobject.DayouWordOrderProcessLogJsonObject;
import com.iesms.openservices.photovoltaic.jsonobject.DayouWordOrderStatusSummaryJsonObject;
import com.iesms.openservices.photovoltaic.typehandler.JsonObjectTypeHandler;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/5/25
 */
@Data
@Accessors(chain = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class DayouWorkOrder implements Serializable {

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 工单类型 抢修 缺陷 巡检
     */
    private String workOrderType;

    /**
     * 工单编号
     */
    private String workOderNo;

    /**
     * 站点名称
     */
    private String stationName;

    /**
     * 地市
     */
    private String city;

    /**
     * 区县
     */
    private String districts;

    /**
     * 站点地址
     */
    private String stationAddress;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date finishTime;

    /**
     * 完成人
     */
    private String finishPerson;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系方式
     */
    private String contactsWay;

    /**
     * 工单状态  待派发 待接收 待处理 已挂起 待挂起 待完结 已完成
     */
    private String workOrderStatus;

    /**
     * 计划开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planStartTime;

    /**
     * 计划结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planEndTime;

    /**
     * 故障开始时间、缺陷发现时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 故障结束时间、缺陷完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 工单时效
     */
    private String workOrderHour;

    /**
     * 关联设备
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private List<String> device;

    /**
     * 巡检明细
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private List<DayouWordOrderInspectionDetailsJsonObject> inspectionDetails;

    /**
     * 状态汇总
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private List<DayouWordOrderStatusSummaryJsonObject> statusSummary;

    /**
     * 流程日志信息
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private List<DayouWordOrderProcessLogJsonObject> processLog;

    /**
     * 其他信息
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private DayouWordOrderOtherInfoJsonObject otherInfo;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
}
