package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/8
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(value = "a_event_show", autoResultMap = true)
public class EventShow implements Serializable {

    private static final long serialVersionUID = -1977028697093083857L;

    /**
     * 主键标识
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 事件编号
     */
    private String eventNo;

    /**
     * 事件名称
     */
    private String eventName;

    /**
     * 事件开始时间
     */
    private Date eventStartTime;

    /**
     * 事件工业持续时长
     */
    private Integer eventGyTime;

    /**
     * 事件商业楼宇持续时长
     */
    private Integer eventSyTime;

    /**
     * 用户数量
     */
    private Integer eventUsers;

    /**
     * 用户列表
     */
    private Object eventUsersList;

    /**
     * 商业楼宇数量
     */
    private Integer eventBuildings;

    /**
     * 工业企业数量
     */
    private Integer eventCompany;

    /**
     * 事件可调负荷
     */
    private String eventLoad;

    /**
     * 创建时间
     */
    private Date createdTime;

    /**
     * 0：初始，1：下发成功，2：下发失败
     */
    private Integer status;
}
