package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * 电网关系表
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class GridRela extends IesmsNormalEntity {

    private static final long serialVersionUID = 5808699858767413152L;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 弹网资源标识
     */
    private Long gridResId;

    /**
     * 上级电网资源标识
     */
    private Long upperGridResId;
}
