package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import com.iesms.openservices.photovoltaic.enums.GridResSortNoEnum;
import com.iesms.openservices.photovoltaic.enums.GridResStatusEnum;
import com.iesms.openservices.photovoltaic.jsonobject.*;
import com.iesms.openservices.photovoltaic.typehandler.JsonObjectTypeHandler;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.Date;

/**
 * 电网资源
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class GridResource extends IesmsNormalEntity {

    private static final long serialVersionUID = 5037957801170896912L;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 电网资源分类编号
     * @see GridResSortNoEnum
     */
    private String gridResSortNo;

    /**
     * 电网资源编号
     */
    private String gridResNo;

    /**
     * 电网资源名称
     */
    private String gridResName;

    /**
     * 电网资源说明
     */
    private String gridResDesc;

    /**
     * 电网资源地址
     */
    private String gridResAddr;

    /**
     * 电网资源状态
     * @see GridResStatusEnum
     */
    private Integer gridResStatus;

    /**
     * 电网资源级别
     */
    private Integer gridResLevel;

    /**
     * 上级电网资源标识 为0表示无上级
     */
    private Long parentId;

    /**
     * 其他基本属性
     * 使用字段类型处理器时，必须开启映射注解 @TableName(autoResultMap = true)。否则插入没问题，但查询时该字段会为空。
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private GridResourceOtherBasicAttrJsonObject otherBasicAttr;

    /**
     * 联系信息属性
     * 使用字段类型处理器时，必须开启映射注解 @TableName(autoResultMap = true)。否则插入没问题，但查询时该字段会为空。
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private GridResourceContactInfoAttrJsonObject contactInfoAttr;

    /**
     * 地理位置属性
     * 使用字段类型处理器时，必须开启映射注解 @TableName(autoResultMap = true)。否则插入没问题，但查询时该字段会为空。
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private GridResourceGeoLocationAttrJsonObject geoLocationAttr;

    /**
     * 弹性能力属性
     * 使用字段类型处理器时，必须开启映射注解 @TableName(autoResultMap = true)。否则插入没问题，但查询时该字段会为空。
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private GridResourceElasticCapacityAttrJsonObject elasticCapacityAttr;

    /**
     * 可调资源属性
     * 使用字段类型处理器时，必须开启映射注解 @TableName(autoResultMap = true)。否则插入没问题，但查询时该字段会为空。
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private GridResourceAdjustableResourceAttrJsonObject adjustableResourceAttr;

    /**
     * 电压等级
     */
    private String voltageClass;

    /**
     * 区域编码
     */
    private String adcode;

    /**
     * 投运人
     */
    private String gotorunner;

    /**
     * 投运日期
     */
    private Date gotorunDate;

    /**
     * 投运备注
     */
    private String gotorunRemark;

    /**
     * 暂停人
     */
    private String pauser;

    /**
     * 暂停日期
     */
    private Date pauseDate;

    /**
     * 暂停备注
     */
    private String pauseRemark;

    /**
     * 退运人
     */
    private String stoprunner;

    /**
     * 退运日期
     */
    private String stoprunDate;

    /**
     * 退运备注
     */
    private String stoprunRemark;
}
