package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 计费方案设置表--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-10
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class MbCustBillingScheme extends IesmsNormalEntity implements Serializable {

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 用能点标识
     */
    private Long cePointId;

    /**
     * 用能点分类;1 – 用电；
     * 2 – 用水；
     * 3 – 用气；
     * 4 – 用热；
     * 5 - 用汽；
     */
    private Integer cePointSort;

    /**
     * 计量计费类型;1 - 计量计价；2 - 基本电费；3 - 立调电费；
     */
    private Integer mbType;

    /**
     * 计量计费模板标识
     */
    private Long tmplMeteringBillingId;


}
