package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liumu
 * @date 2022-01-20 14:05
 * 储能运行调度方案
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class MgosSeOsScheme extends IesmsNormalEntity {

    private static final long serialVersionUID = -7406900647678441416L;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 储能站标识
     */
    private Long seStationId;

    /**
     * 方案编号
     */
    private String seOsSchemeNo;

    /**
     * 方案名称
     */
    private String seOsSchemeName;

    /**
     * 方案说明
     */
    private String seOsSchemeDesc;

    /**
     * 方案状态;1 - 初始（待投放）；2 - 已投放（待启用）；3 - 已启用；4 - 已完成（计划结束完成）；5 - 提前结束（提前结束完成）；
     */
    private Integer seOsSchemeStatus;

    /**
     * 方案明细;{
     "discharge_soc_limit": 10.0,                       // 放电上限（SOC，单位：%）
     "charge_and_discharge_strategies": [{
     "start_time_label": "09:00",                    // 起始时间（格式：HH:mm）
     "end_time_label": "11:00",                     // 结束时间（格式：HH:mm）
     "type": "charge",                                   // charge - 充电；discharge - 放电
     "power": 1000.0                                    // 功率（单位：kW）
     }, {
     "start_time_label": "15:00",                    // 起始时间（格式：HH:mm）
     "end_time_label": "17:00",                     // 结束时间（格式：HH:mm）
     "type": "discharge",                               // charge - 充电；discharge - 放电
     "power": 800.0                                    // 功率（单位：kW）
     }]
     }
     */
    private String seOsSchemeDetail;

    /**
     * 方案模板标识
     */
    private Long tmplSeOsSchemeId;

    /**
     * 计划开始日期
     */
    private Date plannedStartDate;

    /**
     * 计划结束日期
     */
    private Date plannedEndDate;

    /**
     * 实际开始时间
     */
    private Date actualStartTime;

    /**
     * 实际结束时间
     */
    private Date actualEndTime;

    /**
     * 方案投放人
     */
    private String seOsSchemePutinPerson;

    /**
     * 方案投放时间
     */
    private Date seOsSchemePutinTime;

    /**
     * 方案投放脚本
     */
    private String seOsSchemePutinScript;
}
