package com.iesms.openservices.photovoltaic.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author liumu
 * @date 2022-01-20 16:00
 * 储能运行调度方案信息
 */
@Data
public class MgosSeOsSchemeInfo implements Serializable {

    private static final long serialVersionUID = 1235262783372041461L;

    /**
     * 方案id
     */
    private Long id;

    /**
     * 储能电站名称
     */
    private String ceStationName;

    /**
     * 计划开始日期
     */
    private String plannedStartDate;

    /**
     * 计划结束日期
     */
    private String plannedEndDate;

    /**
     * 方案名称
     */
    private String seOsSchemeName;

    /**
     * 方案明细
     */
    private List<TmplSeOsSchemeDetail> tmplSeOsSchemeDetail;

    /**
     * 方案明细String
     */
    private String tmplSeOsSchemeDetailStr;

    /**
     * 放电上限
     */
    private BigDecimal dischargeSocLimit;
}
