package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 用能客户--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-10
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PhoCeCust extends IesmsNormalEntity implements Serializable {

    /**
     * 用能客户类型;1 - 企业；2 - 个人；11 - 公用配电台区；12 - 分布式光伏电站；41 - 热力站；
     */
    private Integer ceCustType;

    /**
     * 用能客户证件号码
     */
    private String ceCustCredNo;

    /**
     * 用能客户证件附件
     */
    private String ceCustCredAttach;

    /**
     * 联系人
     */
    private String contacter;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 邮政编码
     */
    private String contactPostcode;

    /**
     * 联系地址
     */
    private String contactAddress;

    /**
     * 电子邮箱
     */
    private String contactEmail;

    /**
     * 手机号码
     */
    private String contactMobile;

    /**
     * 传真号码
     */
    private String contactFax;

    /**
     * 合同容量
     */
    private BigDecimal contractCapacity;

    /**
     * 立户日期
     */
    private Date openCustDate;

    /**
     * 是否用电
     */
    private Boolean isEnableElec;

    /**
     * 用电分类;编码 CE_CONS_ELEC_SORT：
     * 1 - 高压；2 - 低压非居民；3 - 低压居民；
     */
    private String consElecSort;

    /**
     * 用电性质;编码 CE_CONS_ELEC_PROP：
     * A – 大型专变用户；
     * B – 中小型专变用户；
     * C – 三相一般工商业用户；
     * D – 单相一般工商业用户；
     * E – 居民用户；
     */
    private String consElecProp;

    /**
     * 用电投入日期
     */
    private Date consElecRunDate;

    /**
     * 用电抄表例日
     */
    private Integer consElecReadingDay;

    /**
     * 用电层级
     */
    private Integer consElecLevel;

    /**
     * 上级用能客户（用电）;无上级用能客户标识填0
     */
    private Long parentElecCustId;

    /**
     * 是否用水
     */
    private Boolean isEnableWater;

    /**
     * 用水分类;编码 CE_CONS_WATER_SORT
     */
    private String consWaterSort;

    /**
     * 用水投入日期
     */
    private Date consWaterRunDate;

    /**
     * 用水抄表例日
     */
    private Integer consWaterReadingDay;

    /**
     * 用水层级
     */
    private Integer consWaterLevel;

    /**
     * 上级用能客户（用水）;无上级用能客户标识填0
     */
    private Long parentWaterCustId;

    /**
     * 是否用气
     */
    private Boolean isEnableGas;

    /**
     * 用气分类;编码 CE_CONS_GAS_SORT
     */
    private String consGasSort;

    /**
     * 用气投入日期
     */
    private Date consGasRunDate;

    /**
     * 用气抄表例日
     */
    private Integer consGasReadingDay;

    /**
     * 用气层级
     */
    private Integer consGasLevel;

    /**
     * 上级用能客户（用气）
     */
    private Long parentGasCustId;

    /**
     * 是否用热
     */
    private Boolean isEnableHeat;

    /**
     * 用热分类;编码 CE_CONS_HEAT_SORT
     */
    private String consHeatSort;

    /**
     * 用热投入日期
     */
    private Date consHeatRunDate;

    /**
     * 用热抄表例日
     */
    private Integer consHeatReadingDay;

    /**
     * 用热层级
     */
    private Integer consHeatLevel;

    /**
     * 上级用能客户（用热）;无上级用能客户标识填0
     */
    private Long parentHeatCustId;

    /**
     * 是否用汽
     */
    private Boolean isEnableSteam;

    /**
     * 用汽分类;编码 CE_CONS_STEAM_SORT
     */
    private String consSteamSort;

    /**
     * 用汽投入日期
     */
    private Date consSteamRunDate;

    /**
     * 用汽抄表例日
     */
    private Integer consSteamReadingDay;

    /**
     * 用汽层级
     */
    private Integer consSteamLevel;

    /**
     * 上级用能客户（用汽）;无上级用能客户标识填0
     */
    private Long parentSteamCustId;

    /**
     * 用能客户地址
     */
    private String ceCustAddr;

    /**
     * 用能客户介绍
     */
    private String ceCustIntro;

    /**
     * 用能客户属性集
     */
    private String ceCustProps;

    /**
     * 用能客户业务属性集;
     */
    private String ceCustBizprops;

    /**
     * 行业分类;编码：TRADE_CODE
     */
    private String tradeCode;

    /**
     * 区域编码
     */
    private String adcode;

    /**
     * 城市编码
     */
    private String citycode;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;

}
