package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 用能客户社区资源关系--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-10
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PhoCeCustDistNeighborhoodRela extends IesmsNormalEntity implements Serializable {

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 社区资源标识
     */
    private Long distNeighborhoodResourceId;

}
