package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 用能点--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-13
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PhoCePoint extends IesmsNormalEntity implements Serializable {

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能点编号
     */
    private String cePointNo;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 用能资源标识
     */
    private Long ceResId;

    /**
     * 用能资源类别;1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备；
     */
    private Integer ceResClass;

    /**
     * 用能点名称
     */
    private String cePointName;

    /**
     * 用能点分类;1 – 用电；
     * 2 – 用水；
     * 3 – 用气；
     * 4 – 用热；
     * 5 - 用汽；
     */
    private Integer cePointSort;

    /**
     * 是否结算
     */
    private Boolean isSettlement;

    /**
     * 用能点层级
     */
    private Integer cePointLevel;

    /**
     * 上级用能点标识
     */
    private Long parentId;

    /**
     * 量测点集合
     */
    private String measPointIdList;

    /**
     * 量测计算公式
     */
    private String measCalcRule;

    /**
     * 用能点属性集
     */
    private String cePointProps;

}
