package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 用能资源--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-10
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PhoCeResource extends IesmsNormalEntity implements Serializable {

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能资源类别;1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备；
     */
    private Integer ceResClass;

    /**
     * 用能资源编号
     */
    private String ceResNo;

    /**
     * 用能资源状态;编码CE_RES_STATUS：
     * 10 – 未投运；
     * 20 – 投运；
     * 30 – 暂停；
     * 40 – 退运；
     */
    private String ceResStatus;

    /**
     * 用能资源名称
     */
    private String ceResName;

    /**
     * 用能资源简称
     */
    private String ceResAbbr;

    /**
     * 用能资源说明
     */
    private String ceResDesc;

    /**
     * 用电容量
     */
    private BigDecimal elecCapacity;

    /**
     * 电压等级;编码VOLTAGE_CLASS
     */
    private String voltageClass;

}
