package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 *
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-10
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PkgMeteringBillingElec extends IesmsNormalEntity implements Serializable {

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用电计量计费套餐编号
     */
    private String pkgNo;

    /**
     * 用电计量计费套餐名称
     */
    private String pkgName;

    /**
     * 用电计量计费套餐说明
     */
    private String pkgDesc;

    /**
     * 电度电费模板标识
     */
    private Long tmplDegreeElecBillId;

    /**
     * 基本电费模板标识
     */
    private Long tmplBasicElecBillId;

    /**
     * 立调电费模板标识
     */
    private Long tmplFactorElecBillId;

    /**
     * 费率时段模板标识
     */
    private Long tmplRatePeriodId;

}
