package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 参考单元设置表实体类
 */
@Data
@Accessors(chain = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PvAiopsSample implements Serializable {

    /**
     * 标识
     */
    private Long id;

    /**
     * 一级系统单位编号
     */
    private String primaryOrgNo;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 设备标识
     */
    private Long deviceId;

    /**
     * 样本类型 --1 - 逆变器；2 - PV回路；3 - 组串
     */
    private int sampleType;

    /**
     * 样本名称
     */
    private String sampleName;

    /**
     * 装机容量
     */
    private BigDecimal elecCapacity;

    /**
     * 样本说明
     */
    private String sampleDesc;

    /**
     * 是否有参考单元 0 - 否；1 - 是
     */
    private int isReferenceUnit;
}
