package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PvCustCarbon extends IesmsNormalEntity {

    private static final long serialVersionUID = -4375338172597141654L;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 用能客户标识;分布式光伏电站
     */
    private Long ceCustId;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 一月份
     */
    private BigDecimal monthValue01;

    /**
     * 二月份
     */
    private BigDecimal monthValue02;

    /**
     * 三月份
     */
    private BigDecimal monthValue03;

    /**
     * 四月份
     */
    private BigDecimal monthValue04;

    /**
     * 五月份
     */
    private BigDecimal monthValue05;

    /**
     * 六月份
     */
    private BigDecimal monthValue06;

    /**
     * 七月份
     */
    private BigDecimal monthValue07;

    /**
     * 八月份
     */
    private BigDecimal monthValue08;

    /**
     * 九月份
     */
    private BigDecimal monthValue09;

    /**
     * 十月份
     */
    private BigDecimal monthValue10;

    /**
     * 十一月份
     */
    private BigDecimal monthValue11;

    /**
     * 十二月份
     */
    private BigDecimal monthValue12;

    /**
     * 年累计
     */
    private BigDecimal carbonValueYear;
}
