package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 发电量日统计（按系统单位） 包括分公司
 * @TableName pv_stat_org_day
 */
@TableName(value ="pv_stat_org_day")
@Data
public class PvStatOrgDay implements Serializable {
    /**
     * 统计标识 SnowflakeId
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 系统单位编号
     */
    @TableField(value = "org_no")
    private String orgNo;

    /**
     * 统计日期
     */
    @TableField(value = "date_stat")
    private LocalDate dateStat;

    /**
     * 一小时发电量00 00:00 – 01:00发电量
     */
    @TableField(value = "egen_value_h00")
    private BigDecimal egenValueH00;

    /**
     * 一小时发电量01 01:00 – 02:00发电量
     */
    @TableField(value = "egen_value_h01")
    private BigDecimal egenValueH01;

    /**
     * 一小时发电量02 02:00 – 03:00发电量
     */
    @TableField(value = "egen_value_h02")
    private BigDecimal egenValueH02;

    /**
     * 一小时发电量03
     */
    @TableField(value = "egen_value_h03")
    private BigDecimal egenValueH03;

    /**
     * 一小时发电量04
     */
    @TableField(value = "egen_value_h04")
    private BigDecimal egenValueH04;

    /**
     * 一小时发电量05
     */
    @TableField(value = "egen_value_h05")
    private BigDecimal egenValueH05;

    /**
     * 一小时发电量06
     */
    @TableField(value = "egen_value_h06")
    private BigDecimal egenValueH06;

    /**
     * 一小时发电量07
     */
    @TableField(value = "egen_value_h07")
    private BigDecimal egenValueH07;

    /**
     * 一小时发电量08
     */
    @TableField(value = "egen_value_h08")
    private BigDecimal egenValueH08;

    /**
     * 一小时发电量09
     */
    @TableField(value = "egen_value_h09")
    private BigDecimal egenValueH09;

    /**
     * 一小时发电量10
     */
    @TableField(value = "egen_value_h10")
    private BigDecimal egenValueH10;

    /**
     * 一小时发电量11
     */
    @TableField(value = "egen_value_h11")
    private BigDecimal egenValueH11;

    /**
     * 一小时发电量12
     */
    @TableField(value = "egen_value_h12")
    private BigDecimal egenValueH12;

    /**
     * 一小时发电量13
     */
    @TableField(value = "egen_value_h13")
    private BigDecimal egenValueH13;

    /**
     * 一小时发电量14
     */
    @TableField(value = "egen_value_h14")
    private BigDecimal egenValueH14;

    /**
     * 一小时发电量15
     */
    @TableField(value = "egen_value_h15")
    private BigDecimal egenValueH15;

    /**
     * 一小时发电量16
     */
    @TableField(value = "egen_value_h16")
    private BigDecimal egenValueH16;

    /**
     * 一小时发电量17
     */
    @TableField(value = "egen_value_h17")
    private BigDecimal egenValueH17;

    /**
     * 一小时发电量18
     */
    @TableField(value = "egen_value_h18")
    private BigDecimal egenValueH18;

    /**
     * 一小时发电量19
     */
    @TableField(value = "egen_value_h19")
    private BigDecimal egenValueH19;

    /**
     * 一小时发电量20 20:00 – 21:00发电量
     */
    @TableField(value = "egen_value_h20")
    private BigDecimal egenValueH20;

    /**
     * 一小时发电量21 21:00 – 22:00发电量
     */
    @TableField(value = "egen_value_h21")
    private BigDecimal egenValueH21;

    /**
     * 一小时发电量22 22:00 – 23:00发电量
     */
    @TableField(value = "egen_value_h22")
    private BigDecimal egenValueH22;

    /**
     * 一小时发电量23 23:00 – 00:00发电量
     */
    @TableField(value = "egen_value_h23")
    private BigDecimal egenValueH23;

    /**
     * 日总发电量 一次值
     */
    @TableField(value = "egen_value_day")
    private BigDecimal egenValueDay;

    /**
     * 日总发电示值起始值 一次值
     */
    @TableField(value = "start_egen_value_day")
    private BigDecimal startEgenValueDay;

    /**
     * 日总发电示值截止值 一次值
     */
    @TableField(value = "end_egen_value_day")
    private BigDecimal endEgenValueDay;

    /**
     * 累计总发电量
     */
    @TableField(value = "egen_value_accum")
    private BigDecimal egenValueAccum;

    /**
     * 日收益总额
     */
    @TableField(value = "pv_profit_total_day")
    private BigDecimal pvProfitTotalDay;

    /**
     * 日发电补贴总额
     */
    @TableField(value = "money_subsidy_total_day")
    private BigDecimal moneySubsidyTotalDay;

    /**
     * 日发电补贴明细 {"money_subsidy_country": 500.0, "money_subsidy_province": 400.0, "money_subsidy_city": 300.0, "money_subsidy_district": 200.0}     // money_subsidy_country：国家补贴金额；money_subsidy_province：省补贴金额；money_subsidy_city：市补贴金额；money_subsidy_district：区补贴金额；
     */
    @TableField(value = "money_subsidy_detail_day")
    private Object moneySubsidyDetailDay;

    /**
     * 日上网收益总额
     */
    @TableField(value = "money_online_grid_total_day")
    private BigDecimal moneyOnlineGridTotalDay;

    /**
     * 日上网收益明细 上网收益
{"money_online_grid": 500.0}     // money_online_grid：上网电费收益；
     */
    @TableField(value = "money_online_grid_detail_day")
    private Object moneyOnlineGridDetailDay;

    /**
     * 日自发自用收益总额
     */
    @TableField(value = "money_self_use_total_day")
    private BigDecimal moneySelfUseTotalDay;

    /**
     * 日自发自用收益明细 自发自用收益
{"price_self_use_rate_type": "single", "money_self_use_total": 1.0} // 自发自用电价单费率电费金额；
{"price_self_use_rate_type": "multi", "money_self_use_rate1": 1.0, "money_self_use_rate2": 2.0, "money_self_use_rate3": 3.0, "money_self_use_rate4": 4.0}  // 自发自用电价复费率电费金额；
     */
    @TableField(value = "money_self_use_detail_day")
    private Object moneySelfUseDetailDay;

    /**
     * 日自发自用电量
     */
    @TableField(value = "egen_self_use_value_day")
    private BigDecimal egenSelfUseValueDay;

    /**
     * 累计自发自用电量
     */
    @TableField(value = "egen_self_use_value_accum")
    private BigDecimal egenSelfUseValueAccum;

    /**
     * 累计收益总额
     */
    @TableField(value = "pv_profit_total_accum")
    private BigDecimal pvProfitTotalAccum;

    /**
     * 累计发电补贴总额
     */
    @TableField(value = "money_subsidy_total_accum")
    private BigDecimal moneySubsidyTotalAccum;

    /**
     * 累计发电补贴明细 {"money_subsidy_country": 500.0, "money_subsidy_province": 400.0, "money_subsidy_city": 300.0, "money_subsidy_district": 200.0}     // money_subsidy_country：国家补贴金额；money_subsidy_province：省补贴金额；money_subsidy_city：市补贴金额；money_subsidy_district：区补贴金额；
     */
    @TableField(value = "money_subsidy_detail_accum")
    private Object moneySubsidyDetailAccum;

    /**
     * 累计上网收益总额
     */
    @TableField(value = "money_online_grid_total_accum")
    private BigDecimal moneyOnlineGridTotalAccum;

    /**
     * 累计上网收益明细 上网收益
{"money_online_grid": 500.0}     // money_online_grid：上网电费收益；
     */
    @TableField(value = "money_online_grid_detail_accum")
    private Object moneyOnlineGridDetailAccum;

    /**
     * 累计自发自用收益总额
     */
    @TableField(value = "money_self_use_total_accum")
    private BigDecimal moneySelfUseTotalAccum;

    /**
     * 累计自发自用收益明细 自发自用收益
{"price_self_use_rate_type": "single", "money_self_use_total": 1.0} // 自发自用电价单费率电费金额；
{"price_self_use_rate_type": "multi", "money_self_use_rate1": 1.0, "money_self_use_rate2": 2.0, "money_self_use_rate3": 3.0, "money_self_use_rate4": 4.0}  // 自发自用电价复费率电费金额；
     */
    @TableField(value = "money_self_use_detail_accum")
    private Object moneySelfUseDetailAccum;

    /**
     * 光伏电站数量
     */
    @TableField(value = "pvstation_count")
    private Integer pvstationCount;

    /**
     * 总装机容量 单位为kWp
     */
    @TableField(value = "pv_total_capacity")
    private BigDecimal pvTotalCapacity;

    /**
     * 日等效时数
     */
    @TableField(value = "eq_hours_day")
    private BigDecimal eqHoursDay;

    /**
     * 累计等效时数
     */
    @TableField(value = "eq_hours_accum")
    private BigDecimal eqHoursAccum;

    /**
     * 日节标准煤量
     */
    @TableField(value = "sscq_value_day")
    private BigDecimal sscqValueDay;

    /**
     * 日减二氧化碳排放量
     */
    @TableField(value = "scde_value_day")
    private BigDecimal scdeValueDay;

    /**
     * 日减二氧化硫排放量
     */
    @TableField(value = "ssde_value_day")
    private BigDecimal ssdeValueDay;

    /**
     * 日减森林砍伐面积
     */
    @TableField(value = "sda_value_day")
    private BigDecimal sdaValueDay;

    /**
     * 累计节标准煤量
     */
    @TableField(value = "sscq_value_accum")
    private BigDecimal sscqValueAccum;

    /**
     * 累计减二氧化碳排放量
     */
    @TableField(value = "scde_value_accum")
    private BigDecimal scdeValueAccum;

    /**
     * 累计减二氧化硫排放量
     */
    @TableField(value = "ssde_value_accum")
    private BigDecimal ssdeValueAccum;

    /**
     * 累计减森林砍伐面积
     */
    @TableField(value = "sda_value_accum")
    private BigDecimal sdaValueAccum;

    /**
     * 日上网用电量
     */
    @TableField(value = "egen_ongrid_value_day")
    private BigDecimal egenOngridValueDay;

    /**
     * 创建时间 为0表示为空
     */
    @TableField(value = "gmt_create")
    private Long gmtCreate;

    /**
     * 更新时间 为0表示为空
     */
    @TableField(value = "gmt_modified")
    private Long gmtModified;

    /**
     * 版本号 用于乐观锁
     */
    @TableField(value = "version")
    private Integer version;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PvStatOrgDay other = (PvStatOrgDay) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getOrgNo() == null ? other.getOrgNo() == null : this.getOrgNo().equals(other.getOrgNo()))
            && (this.getDateStat() == null ? other.getDateStat() == null : this.getDateStat().equals(other.getDateStat()))
            && (this.getEgenValueH00() == null ? other.getEgenValueH00() == null : this.getEgenValueH00().equals(other.getEgenValueH00()))
            && (this.getEgenValueH01() == null ? other.getEgenValueH01() == null : this.getEgenValueH01().equals(other.getEgenValueH01()))
            && (this.getEgenValueH02() == null ? other.getEgenValueH02() == null : this.getEgenValueH02().equals(other.getEgenValueH02()))
            && (this.getEgenValueH03() == null ? other.getEgenValueH03() == null : this.getEgenValueH03().equals(other.getEgenValueH03()))
            && (this.getEgenValueH04() == null ? other.getEgenValueH04() == null : this.getEgenValueH04().equals(other.getEgenValueH04()))
            && (this.getEgenValueH05() == null ? other.getEgenValueH05() == null : this.getEgenValueH05().equals(other.getEgenValueH05()))
            && (this.getEgenValueH06() == null ? other.getEgenValueH06() == null : this.getEgenValueH06().equals(other.getEgenValueH06()))
            && (this.getEgenValueH07() == null ? other.getEgenValueH07() == null : this.getEgenValueH07().equals(other.getEgenValueH07()))
            && (this.getEgenValueH08() == null ? other.getEgenValueH08() == null : this.getEgenValueH08().equals(other.getEgenValueH08()))
            && (this.getEgenValueH09() == null ? other.getEgenValueH09() == null : this.getEgenValueH09().equals(other.getEgenValueH09()))
            && (this.getEgenValueH10() == null ? other.getEgenValueH10() == null : this.getEgenValueH10().equals(other.getEgenValueH10()))
            && (this.getEgenValueH11() == null ? other.getEgenValueH11() == null : this.getEgenValueH11().equals(other.getEgenValueH11()))
            && (this.getEgenValueH12() == null ? other.getEgenValueH12() == null : this.getEgenValueH12().equals(other.getEgenValueH12()))
            && (this.getEgenValueH13() == null ? other.getEgenValueH13() == null : this.getEgenValueH13().equals(other.getEgenValueH13()))
            && (this.getEgenValueH14() == null ? other.getEgenValueH14() == null : this.getEgenValueH14().equals(other.getEgenValueH14()))
            && (this.getEgenValueH15() == null ? other.getEgenValueH15() == null : this.getEgenValueH15().equals(other.getEgenValueH15()))
            && (this.getEgenValueH16() == null ? other.getEgenValueH16() == null : this.getEgenValueH16().equals(other.getEgenValueH16()))
            && (this.getEgenValueH17() == null ? other.getEgenValueH17() == null : this.getEgenValueH17().equals(other.getEgenValueH17()))
            && (this.getEgenValueH18() == null ? other.getEgenValueH18() == null : this.getEgenValueH18().equals(other.getEgenValueH18()))
            && (this.getEgenValueH19() == null ? other.getEgenValueH19() == null : this.getEgenValueH19().equals(other.getEgenValueH19()))
            && (this.getEgenValueH20() == null ? other.getEgenValueH20() == null : this.getEgenValueH20().equals(other.getEgenValueH20()))
            && (this.getEgenValueH21() == null ? other.getEgenValueH21() == null : this.getEgenValueH21().equals(other.getEgenValueH21()))
            && (this.getEgenValueH22() == null ? other.getEgenValueH22() == null : this.getEgenValueH22().equals(other.getEgenValueH22()))
            && (this.getEgenValueH23() == null ? other.getEgenValueH23() == null : this.getEgenValueH23().equals(other.getEgenValueH23()))
            && (this.getEgenValueDay() == null ? other.getEgenValueDay() == null : this.getEgenValueDay().equals(other.getEgenValueDay()))
            && (this.getStartEgenValueDay() == null ? other.getStartEgenValueDay() == null : this.getStartEgenValueDay().equals(other.getStartEgenValueDay()))
            && (this.getEndEgenValueDay() == null ? other.getEndEgenValueDay() == null : this.getEndEgenValueDay().equals(other.getEndEgenValueDay()))
            && (this.getEgenValueAccum() == null ? other.getEgenValueAccum() == null : this.getEgenValueAccum().equals(other.getEgenValueAccum()))
            && (this.getPvProfitTotalDay() == null ? other.getPvProfitTotalDay() == null : this.getPvProfitTotalDay().equals(other.getPvProfitTotalDay()))
            && (this.getMoneySubsidyTotalDay() == null ? other.getMoneySubsidyTotalDay() == null : this.getMoneySubsidyTotalDay().equals(other.getMoneySubsidyTotalDay()))
            && (this.getMoneySubsidyDetailDay() == null ? other.getMoneySubsidyDetailDay() == null : this.getMoneySubsidyDetailDay().equals(other.getMoneySubsidyDetailDay()))
            && (this.getMoneyOnlineGridTotalDay() == null ? other.getMoneyOnlineGridTotalDay() == null : this.getMoneyOnlineGridTotalDay().equals(other.getMoneyOnlineGridTotalDay()))
            && (this.getMoneyOnlineGridDetailDay() == null ? other.getMoneyOnlineGridDetailDay() == null : this.getMoneyOnlineGridDetailDay().equals(other.getMoneyOnlineGridDetailDay()))
            && (this.getMoneySelfUseTotalDay() == null ? other.getMoneySelfUseTotalDay() == null : this.getMoneySelfUseTotalDay().equals(other.getMoneySelfUseTotalDay()))
            && (this.getMoneySelfUseDetailDay() == null ? other.getMoneySelfUseDetailDay() == null : this.getMoneySelfUseDetailDay().equals(other.getMoneySelfUseDetailDay()))
            && (this.getEgenSelfUseValueDay() == null ? other.getEgenSelfUseValueDay() == null : this.getEgenSelfUseValueDay().equals(other.getEgenSelfUseValueDay()))
            && (this.getEgenSelfUseValueAccum() == null ? other.getEgenSelfUseValueAccum() == null : this.getEgenSelfUseValueAccum().equals(other.getEgenSelfUseValueAccum()))
            && (this.getPvProfitTotalAccum() == null ? other.getPvProfitTotalAccum() == null : this.getPvProfitTotalAccum().equals(other.getPvProfitTotalAccum()))
            && (this.getMoneySubsidyTotalAccum() == null ? other.getMoneySubsidyTotalAccum() == null : this.getMoneySubsidyTotalAccum().equals(other.getMoneySubsidyTotalAccum()))
            && (this.getMoneySubsidyDetailAccum() == null ? other.getMoneySubsidyDetailAccum() == null : this.getMoneySubsidyDetailAccum().equals(other.getMoneySubsidyDetailAccum()))
            && (this.getMoneyOnlineGridTotalAccum() == null ? other.getMoneyOnlineGridTotalAccum() == null : this.getMoneyOnlineGridTotalAccum().equals(other.getMoneyOnlineGridTotalAccum()))
            && (this.getMoneyOnlineGridDetailAccum() == null ? other.getMoneyOnlineGridDetailAccum() == null : this.getMoneyOnlineGridDetailAccum().equals(other.getMoneyOnlineGridDetailAccum()))
            && (this.getMoneySelfUseTotalAccum() == null ? other.getMoneySelfUseTotalAccum() == null : this.getMoneySelfUseTotalAccum().equals(other.getMoneySelfUseTotalAccum()))
            && (this.getMoneySelfUseDetailAccum() == null ? other.getMoneySelfUseDetailAccum() == null : this.getMoneySelfUseDetailAccum().equals(other.getMoneySelfUseDetailAccum()))
            && (this.getPvstationCount() == null ? other.getPvstationCount() == null : this.getPvstationCount().equals(other.getPvstationCount()))
            && (this.getPvTotalCapacity() == null ? other.getPvTotalCapacity() == null : this.getPvTotalCapacity().equals(other.getPvTotalCapacity()))
            && (this.getEqHoursDay() == null ? other.getEqHoursDay() == null : this.getEqHoursDay().equals(other.getEqHoursDay()))
            && (this.getEqHoursAccum() == null ? other.getEqHoursAccum() == null : this.getEqHoursAccum().equals(other.getEqHoursAccum()))
            && (this.getSscqValueDay() == null ? other.getSscqValueDay() == null : this.getSscqValueDay().equals(other.getSscqValueDay()))
            && (this.getScdeValueDay() == null ? other.getScdeValueDay() == null : this.getScdeValueDay().equals(other.getScdeValueDay()))
            && (this.getSsdeValueDay() == null ? other.getSsdeValueDay() == null : this.getSsdeValueDay().equals(other.getSsdeValueDay()))
            && (this.getSdaValueDay() == null ? other.getSdaValueDay() == null : this.getSdaValueDay().equals(other.getSdaValueDay()))
            && (this.getSscqValueAccum() == null ? other.getSscqValueAccum() == null : this.getSscqValueAccum().equals(other.getSscqValueAccum()))
            && (this.getScdeValueAccum() == null ? other.getScdeValueAccum() == null : this.getScdeValueAccum().equals(other.getScdeValueAccum()))
            && (this.getSsdeValueAccum() == null ? other.getSsdeValueAccum() == null : this.getSsdeValueAccum().equals(other.getSsdeValueAccum()))
            && (this.getSdaValueAccum() == null ? other.getSdaValueAccum() == null : this.getSdaValueAccum().equals(other.getSdaValueAccum()))
            && (this.getEgenOngridValueDay() == null ? other.getEgenOngridValueDay() == null : this.getEgenOngridValueDay().equals(other.getEgenOngridValueDay()))
            && (this.getGmtCreate() == null ? other.getGmtCreate() == null : this.getGmtCreate().equals(other.getGmtCreate()))
            && (this.getGmtModified() == null ? other.getGmtModified() == null : this.getGmtModified().equals(other.getGmtModified()))
            && (this.getVersion() == null ? other.getVersion() == null : this.getVersion().equals(other.getVersion()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getOrgNo() == null) ? 0 : getOrgNo().hashCode());
        result = prime * result + ((getDateStat() == null) ? 0 : getDateStat().hashCode());
        result = prime * result + ((getEgenValueH00() == null) ? 0 : getEgenValueH00().hashCode());
        result = prime * result + ((getEgenValueH01() == null) ? 0 : getEgenValueH01().hashCode());
        result = prime * result + ((getEgenValueH02() == null) ? 0 : getEgenValueH02().hashCode());
        result = prime * result + ((getEgenValueH03() == null) ? 0 : getEgenValueH03().hashCode());
        result = prime * result + ((getEgenValueH04() == null) ? 0 : getEgenValueH04().hashCode());
        result = prime * result + ((getEgenValueH05() == null) ? 0 : getEgenValueH05().hashCode());
        result = prime * result + ((getEgenValueH06() == null) ? 0 : getEgenValueH06().hashCode());
        result = prime * result + ((getEgenValueH07() == null) ? 0 : getEgenValueH07().hashCode());
        result = prime * result + ((getEgenValueH08() == null) ? 0 : getEgenValueH08().hashCode());
        result = prime * result + ((getEgenValueH09() == null) ? 0 : getEgenValueH09().hashCode());
        result = prime * result + ((getEgenValueH10() == null) ? 0 : getEgenValueH10().hashCode());
        result = prime * result + ((getEgenValueH11() == null) ? 0 : getEgenValueH11().hashCode());
        result = prime * result + ((getEgenValueH12() == null) ? 0 : getEgenValueH12().hashCode());
        result = prime * result + ((getEgenValueH13() == null) ? 0 : getEgenValueH13().hashCode());
        result = prime * result + ((getEgenValueH14() == null) ? 0 : getEgenValueH14().hashCode());
        result = prime * result + ((getEgenValueH15() == null) ? 0 : getEgenValueH15().hashCode());
        result = prime * result + ((getEgenValueH16() == null) ? 0 : getEgenValueH16().hashCode());
        result = prime * result + ((getEgenValueH17() == null) ? 0 : getEgenValueH17().hashCode());
        result = prime * result + ((getEgenValueH18() == null) ? 0 : getEgenValueH18().hashCode());
        result = prime * result + ((getEgenValueH19() == null) ? 0 : getEgenValueH19().hashCode());
        result = prime * result + ((getEgenValueH20() == null) ? 0 : getEgenValueH20().hashCode());
        result = prime * result + ((getEgenValueH21() == null) ? 0 : getEgenValueH21().hashCode());
        result = prime * result + ((getEgenValueH22() == null) ? 0 : getEgenValueH22().hashCode());
        result = prime * result + ((getEgenValueH23() == null) ? 0 : getEgenValueH23().hashCode());
        result = prime * result + ((getEgenValueDay() == null) ? 0 : getEgenValueDay().hashCode());
        result = prime * result + ((getStartEgenValueDay() == null) ? 0 : getStartEgenValueDay().hashCode());
        result = prime * result + ((getEndEgenValueDay() == null) ? 0 : getEndEgenValueDay().hashCode());
        result = prime * result + ((getEgenValueAccum() == null) ? 0 : getEgenValueAccum().hashCode());
        result = prime * result + ((getPvProfitTotalDay() == null) ? 0 : getPvProfitTotalDay().hashCode());
        result = prime * result + ((getMoneySubsidyTotalDay() == null) ? 0 : getMoneySubsidyTotalDay().hashCode());
        result = prime * result + ((getMoneySubsidyDetailDay() == null) ? 0 : getMoneySubsidyDetailDay().hashCode());
        result = prime * result + ((getMoneyOnlineGridTotalDay() == null) ? 0 : getMoneyOnlineGridTotalDay().hashCode());
        result = prime * result + ((getMoneyOnlineGridDetailDay() == null) ? 0 : getMoneyOnlineGridDetailDay().hashCode());
        result = prime * result + ((getMoneySelfUseTotalDay() == null) ? 0 : getMoneySelfUseTotalDay().hashCode());
        result = prime * result + ((getMoneySelfUseDetailDay() == null) ? 0 : getMoneySelfUseDetailDay().hashCode());
        result = prime * result + ((getEgenSelfUseValueDay() == null) ? 0 : getEgenSelfUseValueDay().hashCode());
        result = prime * result + ((getEgenSelfUseValueAccum() == null) ? 0 : getEgenSelfUseValueAccum().hashCode());
        result = prime * result + ((getPvProfitTotalAccum() == null) ? 0 : getPvProfitTotalAccum().hashCode());
        result = prime * result + ((getMoneySubsidyTotalAccum() == null) ? 0 : getMoneySubsidyTotalAccum().hashCode());
        result = prime * result + ((getMoneySubsidyDetailAccum() == null) ? 0 : getMoneySubsidyDetailAccum().hashCode());
        result = prime * result + ((getMoneyOnlineGridTotalAccum() == null) ? 0 : getMoneyOnlineGridTotalAccum().hashCode());
        result = prime * result + ((getMoneyOnlineGridDetailAccum() == null) ? 0 : getMoneyOnlineGridDetailAccum().hashCode());
        result = prime * result + ((getMoneySelfUseTotalAccum() == null) ? 0 : getMoneySelfUseTotalAccum().hashCode());
        result = prime * result + ((getMoneySelfUseDetailAccum() == null) ? 0 : getMoneySelfUseDetailAccum().hashCode());
        result = prime * result + ((getPvstationCount() == null) ? 0 : getPvstationCount().hashCode());
        result = prime * result + ((getPvTotalCapacity() == null) ? 0 : getPvTotalCapacity().hashCode());
        result = prime * result + ((getEqHoursDay() == null) ? 0 : getEqHoursDay().hashCode());
        result = prime * result + ((getEqHoursAccum() == null) ? 0 : getEqHoursAccum().hashCode());
        result = prime * result + ((getSscqValueDay() == null) ? 0 : getSscqValueDay().hashCode());
        result = prime * result + ((getScdeValueDay() == null) ? 0 : getScdeValueDay().hashCode());
        result = prime * result + ((getSsdeValueDay() == null) ? 0 : getSsdeValueDay().hashCode());
        result = prime * result + ((getSdaValueDay() == null) ? 0 : getSdaValueDay().hashCode());
        result = prime * result + ((getSscqValueAccum() == null) ? 0 : getSscqValueAccum().hashCode());
        result = prime * result + ((getScdeValueAccum() == null) ? 0 : getScdeValueAccum().hashCode());
        result = prime * result + ((getSsdeValueAccum() == null) ? 0 : getSsdeValueAccum().hashCode());
        result = prime * result + ((getSdaValueAccum() == null) ? 0 : getSdaValueAccum().hashCode());
        result = prime * result + ((getEgenOngridValueDay() == null) ? 0 : getEgenOngridValueDay().hashCode());
        result = prime * result + ((getGmtCreate() == null) ? 0 : getGmtCreate().hashCode());
        result = prime * result + ((getGmtModified() == null) ? 0 : getGmtModified().hashCode());
        result = prime * result + ((getVersion() == null) ? 0 : getVersion().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", orgNo=").append(orgNo);
        sb.append(", dateStat=").append(dateStat);
        sb.append(", egenValueH00=").append(egenValueH00);
        sb.append(", egenValueH01=").append(egenValueH01);
        sb.append(", egenValueH02=").append(egenValueH02);
        sb.append(", egenValueH03=").append(egenValueH03);
        sb.append(", egenValueH04=").append(egenValueH04);
        sb.append(", egenValueH05=").append(egenValueH05);
        sb.append(", egenValueH06=").append(egenValueH06);
        sb.append(", egenValueH07=").append(egenValueH07);
        sb.append(", egenValueH08=").append(egenValueH08);
        sb.append(", egenValueH09=").append(egenValueH09);
        sb.append(", egenValueH10=").append(egenValueH10);
        sb.append(", egenValueH11=").append(egenValueH11);
        sb.append(", egenValueH12=").append(egenValueH12);
        sb.append(", egenValueH13=").append(egenValueH13);
        sb.append(", egenValueH14=").append(egenValueH14);
        sb.append(", egenValueH15=").append(egenValueH15);
        sb.append(", egenValueH16=").append(egenValueH16);
        sb.append(", egenValueH17=").append(egenValueH17);
        sb.append(", egenValueH18=").append(egenValueH18);
        sb.append(", egenValueH19=").append(egenValueH19);
        sb.append(", egenValueH20=").append(egenValueH20);
        sb.append(", egenValueH21=").append(egenValueH21);
        sb.append(", egenValueH22=").append(egenValueH22);
        sb.append(", egenValueH23=").append(egenValueH23);
        sb.append(", egenValueDay=").append(egenValueDay);
        sb.append(", startEgenValueDay=").append(startEgenValueDay);
        sb.append(", endEgenValueDay=").append(endEgenValueDay);
        sb.append(", egenValueAccum=").append(egenValueAccum);
        sb.append(", pvProfitTotalDay=").append(pvProfitTotalDay);
        sb.append(", moneySubsidyTotalDay=").append(moneySubsidyTotalDay);
        sb.append(", moneySubsidyDetailDay=").append(moneySubsidyDetailDay);
        sb.append(", moneyOnlineGridTotalDay=").append(moneyOnlineGridTotalDay);
        sb.append(", moneyOnlineGridDetailDay=").append(moneyOnlineGridDetailDay);
        sb.append(", moneySelfUseTotalDay=").append(moneySelfUseTotalDay);
        sb.append(", moneySelfUseDetailDay=").append(moneySelfUseDetailDay);
        sb.append(", egenSelfUseValueDay=").append(egenSelfUseValueDay);
        sb.append(", egenSelfUseValueAccum=").append(egenSelfUseValueAccum);
        sb.append(", pvProfitTotalAccum=").append(pvProfitTotalAccum);
        sb.append(", moneySubsidyTotalAccum=").append(moneySubsidyTotalAccum);
        sb.append(", moneySubsidyDetailAccum=").append(moneySubsidyDetailAccum);
        sb.append(", moneyOnlineGridTotalAccum=").append(moneyOnlineGridTotalAccum);
        sb.append(", moneyOnlineGridDetailAccum=").append(moneyOnlineGridDetailAccum);
        sb.append(", moneySelfUseTotalAccum=").append(moneySelfUseTotalAccum);
        sb.append(", moneySelfUseDetailAccum=").append(moneySelfUseDetailAccum);
        sb.append(", pvstationCount=").append(pvstationCount);
        sb.append(", pvTotalCapacity=").append(pvTotalCapacity);
        sb.append(", eqHoursDay=").append(eqHoursDay);
        sb.append(", eqHoursAccum=").append(eqHoursAccum);
        sb.append(", sscqValueDay=").append(sscqValueDay);
        sb.append(", scdeValueDay=").append(scdeValueDay);
        sb.append(", ssdeValueDay=").append(ssdeValueDay);
        sb.append(", sdaValueDay=").append(sdaValueDay);
        sb.append(", sscqValueAccum=").append(sscqValueAccum);
        sb.append(", scdeValueAccum=").append(scdeValueAccum);
        sb.append(", ssdeValueAccum=").append(ssdeValueAccum);
        sb.append(", sdaValueAccum=").append(sdaValueAccum);
        sb.append(", egenOngridValueDay=").append(egenOngridValueDay);
        sb.append(", gmtCreate=").append(gmtCreate);
        sb.append(", gmtModified=").append(gmtModified);
        sb.append(", version=").append(version);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}